/*
 * Decompiled with CFR 0.152.
 */
package elki.itemsetmining;

import elki.Algorithm;
import elki.database.Database;
import elki.result.FrequentItemsetsResult;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;

public abstract class AbstractFrequentItemsetAlgorithm
implements Algorithm {
    private double minsupp;
    protected int minlength = 0;
    protected int maxlength = Integer.MAX_VALUE;

    public AbstractFrequentItemsetAlgorithm(double minsupp, int minlength, int maxlength) {
        this.minsupp = minsupp;
        this.minlength = minlength;
        this.maxlength = maxlength > 0 ? maxlength : Integer.MAX_VALUE;
    }

    public AbstractFrequentItemsetAlgorithm(double minsupp) {
        this(minsupp, 0, Integer.MAX_VALUE);
    }

    public FrequentItemsetsResult autorun(Database database) {
        return (FrequentItemsetsResult)super.autorun(database);
    }

    public int getMinimumSupport(int size) {
        return (int)(this.minsupp < 1.0 ? Math.ceil(this.minsupp * (double)size) : this.minsupp);
    }

    public static abstract class Par
    implements Parameterizer {
        public static final OptionID MINSUPP_ID = new OptionID("itemsetmining.minsupp", "Threshold for minimum support as minimally required number of transactions (if > 1) or the minimum frequency (if <= 1).");
        public static final OptionID MINLENGTH_ID = new OptionID("itemsetmining.minlength", "Minimum length of frequent itemsets to report. This can help to reduce the output size to only the most interesting patterns.");
        public static final OptionID MAXLENGTH_ID = new OptionID("itemsetmining.maxlength", "Maximum length of frequent itemsets to report. This can help to reduce the output size to only the most interesting patterns.");
        protected double minsupp;
        protected int minlength = 0;
        protected int maxlength = Integer.MAX_VALUE;

        public void configure(Parameterization config) {
            ((DoubleParameter)new DoubleParameter(MINSUPP_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.minsupp = x;
            });
            ((IntParameter)((IntParameter)new IntParameter(MINLENGTH_ID).setOptional(true)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.minlength = x;
            });
            ((IntParameter)((IntParameter)new IntParameter(MAXLENGTH_ID).setOptional(true)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.maxlength = x;
            });
        }
    }
}

