/*
 * Decompiled with CFR 0.152.
 */
package elki.itemsetmining;

import elki.data.BitVector;
import elki.data.SparseFeatureVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.itemsetmining.AbstractFrequentItemsetAlgorithm;
import elki.itemsetmining.Itemset;
import elki.itemsetmining.OneItemset;
import elki.itemsetmining.SparseItemset;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.result.FrequentItemsetsResult;
import elki.result.Metadata;
import elki.utilities.Priority;
import elki.utilities.datastructures.arrays.IntegerArrayQuickSort;
import elki.utilities.documentation.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

@Reference(authors="J. Han, J. Pei, Y. Yin", title="Mining frequent patterns without candidate generation", booktitle="Proc. ACM SIGMOD Int. Conf. Management of Data (SIGMOD 2000)", url="https://doi.org/10.1145/342009.335372", bibkey="DBLP:conf/sigmod/HanPY00")
@Priority(value=200)
public class FPGrowth
extends AbstractFrequentItemsetAlgorithm {
    private static final Logging LOG = Logging.getLogger(FPGrowth.class);
    private static final String STAT = FPGrowth.class.getName() + ".";

    public FPGrowth(double minsupp, int minlength, int maxlength) {
        super(minsupp, minlength, maxlength);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.BIT_VECTOR_FIELD});
    }

    public FrequentItemsetsResult run(Relation<BitVector> relation) {
        int dim = RelationUtil.dimensionality(relation);
        final VectorFieldTypeInformation meta = RelationUtil.assumeVectorField(relation);
        int minsupp = this.getMinimumSupport(relation.size());
        LOG.verbose((CharSequence)"Finding item frequencies for ordering.");
        int[] counts = this.countItemSupport(relation, dim);
        int[] iidx = new int[dim];
        final int[] idx = this.buildIndex(counts, iidx, minsupp);
        int items = idx.length;
        LOG.statistics((Statistic)new LongStatistic(STAT + "raw-items", (long)dim));
        LOG.statistics((Statistic)new LongStatistic(STAT + "raw-transactions", (long)relation.size()));
        LOG.statistics((Statistic)new DoubleStatistic(STAT + "minsupp-relative", (double)minsupp / (double)relation.size()));
        LOG.statistics((Statistic)new LongStatistic(STAT + "minsupp-absolute", (long)minsupp));
        LOG.verbose((CharSequence)"Building FP-Tree.");
        Duration ctime = LOG.newDuration(STAT + "fp-tree.construction.time").begin();
        FPTree tree = this.buildFPTree(relation, iidx, items);
        if (LOG.isStatistics()) {
            tree.logStatistics();
        }
        if (LOG.isDebuggingFinest()) {
            StringBuilder buf = new StringBuilder(10000).append("FP-tree:\n");
            tree.appendTo(buf, new FPNode.Translator(){

                @Override
                public StringBuilder appendTo(StringBuilder buf, int i) {
                    String l = meta.getLabel(idx[i]);
                    return l != null ? buf.append(l) : buf.append(i);
                }
            });
            LOG.debugFinest((CharSequence)buf.toString());
        }
        tree.reduceMemory();
        LOG.statistics((Statistic)ctime.end());
        LOG.verbose((CharSequence)"Extracting frequent patterns.");
        Duration etime = LOG.newDuration(STAT + "fp-growth.extraction.time").begin();
        final IndefiniteProgress itemp = LOG.isVerbose() ? new IndefiniteProgress("Frequent itemsets", LOG) : null;
        final ArrayList<Itemset> solution = new ArrayList<Itemset>();
        tree.extract(minsupp, this.minlength, this.maxlength, true, new FPTree.Collector(){

            @Override
            public void collect(int support, int[] data, int start, int plen) {
                if (plen - start == 1) {
                    solution.add(new OneItemset(idx[data[start]], support));
                    LOG.incrementProcessed((AbstractProgress)itemp);
                    return;
                }
                int[] indices = new int[plen - start];
                int j = 0;
                for (int i = start; i < plen; ++i) {
                    indices[j++] = idx[data[i]];
                }
                Arrays.sort(indices);
                solution.add(new SparseItemset(indices, support));
                LOG.incrementProcessed((AbstractProgress)itemp);
            }
        });
        LOG.setCompleted(itemp);
        Collections.sort(solution);
        LOG.statistics((Statistic)etime.end());
        LOG.statistics((Statistic)new LongStatistic(STAT + "frequent-itemsets", (long)solution.size()));
        FrequentItemsetsResult result = new FrequentItemsetsResult(solution, (VectorFieldTypeInformation<BitVector>)meta, relation.size());
        Metadata.of((Object)result).setLongName("FP-Growth");
        return result;
    }

    private int[] countItemSupport(Relation<BitVector> relation, int dim) {
        int[] counts = new int[dim];
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Finding frequent 1-items", relation.size(), LOG) : null;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            SparseFeatureVector bv = (SparseFeatureVector)relation.get((DBIDRef)iditer);
            int it = bv.iter();
            while (bv.iterValid(it)) {
                int n = bv.iterDim(it);
                counts[n] = counts[n] + 1;
                it = bv.iterAdvance(it);
            }
            LOG.incrementProcessed((AbstractProgress)prog);
            iditer.advance();
        }
        LOG.ensureCompleted(prog);
        return counts;
    }

    private FPTree buildFPTree(Relation<BitVector> relation, int[] iidx, int items) {
        FPTree tree = new FPTree(items);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Building FP-tree", relation.size(), LOG) : null;
        int[] buf = new int[items];
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            int l = 0;
            SparseFeatureVector bv = (SparseFeatureVector)relation.get((DBIDRef)iditer);
            int it = bv.iter();
            while (bv.iterValid(it)) {
                int i = iidx[bv.iterDim(it)];
                if (i >= 0) {
                    buf[l++] = i;
                }
                it = bv.iterAdvance(it);
            }
            if (l >= this.minlength) {
                Arrays.sort(buf, 0, l);
                tree.insert(buf, 0, l, 1);
            }
            LOG.incrementProcessed((AbstractProgress)prog);
            iditer.advance();
        }
        LOG.ensureCompleted(prog);
        return tree;
    }

    private int[] buildIndex(int[] counts, int[] positions, int minsupp) {
        int i;
        int numfreq = 0;
        for (int i2 = 0; i2 < counts.length; ++i2) {
            if (counts[i2] < minsupp) continue;
            ++numfreq;
        }
        int[] idx = new int[numfreq];
        int j = 0;
        for (i = 0; i < counts.length; ++i) {
            if (counts[i] < minsupp) continue;
            idx[j++] = i;
        }
        IntegerArrayQuickSort.sort((int[])idx, (x, y) -> Integer.compare(counts[y], counts[x]));
        Arrays.fill(positions, -1);
        for (i = 0; i < idx.length; ++i) {
            positions[idx[i]] = i;
        }
        return idx;
    }

    public static class Par
    extends AbstractFrequentItemsetAlgorithm.Par {
        public FPGrowth make() {
            return new FPGrowth(this.minsupp, this.minlength, this.maxlength);
        }
    }

    public static class FPNode {
        FPNode parent;
        FPNode sibling;
        int key;
        int count = 0;
        int numchildren = 0;
        FPNode[] children = EMPTY_CHILDREN;
        static final FPNode[] EMPTY_CHILDREN = new FPNode[0];
        final int INITIAL_SIZE = 7;
        private static final char[] SPACES = "                ".toCharArray();

        public FPNode(FPNode parent, int key) {
            this.parent = parent;
            this.key = key;
        }

        public void insert(FPTree tree, int[] buf, int i, int l, int weight) {
            this.count += weight;
            if (i == l) {
                return;
            }
            int label = buf[i];
            for (int j = 0; j < this.numchildren; ++j) {
                FPNode child = this.children[j];
                if (child.key != label) continue;
                child.insert(tree, buf, i + 1, l, weight);
                return;
            }
            if (this.numchildren == this.children.length) {
                this.ensureSize();
            }
            FPNode fPNode = tree.newNode(this, label);
            this.children[this.numchildren++] = fPNode;
            FPNode sub = fPNode;
            sub.insert(tree, buf, i + 1, l, weight);
        }

        private void ensureSize() {
            if (this.children == EMPTY_CHILDREN) {
                this.children = new FPNode[1];
                return;
            }
            int newsize = this.children.length == 1 ? 7 : this.children.length << 1;
            this.children = Arrays.copyOf(this.children, newsize);
        }

        public StringBuilder appendTo(StringBuilder buf, Translator t) {
            return this.appendTo(buf, t, 0);
        }

        private StringBuilder appendTo(StringBuilder buf, Translator t, int depth) {
            if (this.key >= 0) {
                t.appendTo(buf, this.key).append(": ");
            }
            buf.append(this.count).append('\n');
            for (int i = 0; i < this.numchildren; ++i) {
                for (int j = depth; j > 0; j -= SPACES.length) {
                    buf.append(SPACES, 0, Math.min(j, SPACES.length));
                }
                this.children[i].appendTo(buf, t, depth + 1);
            }
            return buf;
        }

        public void reduceMemory() {
            if (this.children == null) {
                return;
            }
            for (int i = 0; i < this.numchildren; ++i) {
                this.children[i].reduceMemory();
            }
            this.children = null;
        }

        static interface Translator {
            public StringBuilder appendTo(StringBuilder var1, int var2);
        }
    }

    public static class FPTree
    extends FPNode {
        FPNode[] header;
        int nodes = 1;

        public FPTree(int items) {
            super(null, -1);
            this.header = new FPNode[items];
        }

        public void insert(int[] buf, int i, int l, int weight) {
            this.insert(this, buf, i, l, weight);
        }

        public FPNode newNode(FPNode parent, int label) {
            FPNode node = new FPNode(parent, label);
            node.sibling = this.header[label];
            this.header[label] = node;
            ++this.nodes;
            return node;
        }

        public void extract(int minsupp, int minlength, int maxlength, boolean destruct, Collector col) {
            int[] buf = new int[this.header.length];
            int[] buf2 = new int[this.header.length];
            int[] buf3 = new int[this.header.length];
            int stop = minlength > 1 ? minlength - 1 : 0;
            FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Extracting itemsets", this.header.length - stop, LOG) : null;
            for (int j = this.header.length - 1; j >= stop; --j) {
                this.extract(minsupp, minlength, maxlength, j, buf, 0, buf2, buf3, destruct, col);
                LOG.incrementProcessed((AbstractProgress)prog);
            }
            LOG.ensureCompleted(prog);
        }

        private void extract(int minsupp, int minlength, int maxlength, int item, int[] postfix, int plen, int[] buf2, int[] buf3, boolean destruct, Collector col) {
            if (this.header[item] == null) {
                return;
            }
            if (this.header[item].sibling == null && this.header[item].numchildren == 0) {
                if (this.header[item].count >= minsupp) {
                    this.extractLinear(this.header[item].count, minlength, maxlength, item, postfix, plen, buf2, col);
                }
                if (destruct) {
                    --this.header[item].parent.numchildren;
                    this.header[item] = null;
                }
                return;
            }
            int support = 0;
            FPNode cur = this.header[item];
            while (cur != null) {
                support += cur.count;
                cur = cur.sibling;
            }
            if (support < minsupp) {
                return;
            }
            Arrays.fill(buf3, 0);
            cur = this.header[item];
            while (cur != null) {
                FPNode parent = cur.parent;
                while (parent.key >= 0) {
                    int n = parent.key;
                    buf3[n] = buf3[n] + cur.count;
                    parent = parent.parent;
                }
                cur = cur.sibling;
            }
            int mminlength = minlength - (plen + 1);
            if (mminlength > 0) {
                int fparents = 0;
                for (int i = 0; i < item; ++i) {
                    if (buf3[i] < minsupp) continue;
                    ++fparents;
                }
                if (fparents < mminlength) {
                    return;
                }
            }
            int last = item - 1;
            FPTree proj = new FPTree(item);
            FPNode cur2 = this.header[item];
            while (cur2 != null) {
                int j = buf2.length;
                FPNode parent = cur2.parent;
                while (parent.key >= 0) {
                    if (buf3[parent.key] >= minsupp) {
                        buf2[--j] = parent.key;
                    }
                    parent = parent.parent;
                }
                if (buf2.length - j >= mminlength) {
                    proj.insert(proj, buf2, j, buf2.length, cur2.count);
                }
                cur2 = cur2.sibling;
            }
            proj.reduceMemory();
            postfix[plen++] = item;
            if (plen >= minlength && plen <= maxlength) {
                col.collect(support, postfix, 0, plen);
            }
            for (int j = last; j >= 0; --j) {
                proj.extract(minsupp, minlength, maxlength, j, postfix, plen, buf2, buf3, destruct, col);
            }
            if (destruct) {
                this.header[item] = null;
            }
        }

        private void extractLinear(int supp, int minlength, int maxlength, int item, int[] postfix, int plen, int[] buf2, Collector col) {
            int mminlength = minlength - plen;
            if (item + 1 < mminlength) {
                return;
            }
            postfix[plen++] = item;
            if (plen >= minlength && plen <= maxlength) {
                col.collect(supp, postfix, 0, plen);
            }
            if (plen == maxlength) {
                return;
            }
            assert (this.header[item] != null);
            FPNode p = this.header[item].parent;
            while (p.key >= 0 && p.key >= mminlength) {
                this.extractLinear(supp, minlength, maxlength, p.key, postfix, plen, buf2, col);
                p = p.parent;
            }
        }

        public void logStatistics() {
            LOG.statistics((Statistic)new LongStatistic(STAT + "items", (long)this.header.length));
            LOG.statistics((Statistic)new LongStatistic(STAT + "nodes", (long)this.nodes));
            LOG.statistics((Statistic)new LongStatistic(STAT + "transactions", (long)this.count));
        }

        static interface Collector {
            public void collect(int var1, int[] var2, int var3, int var4);
        }
    }
}

