/*
 * Decompiled with CFR 0.152.
 */
package elki.itemsetmining;

import elki.itemsetmining.Itemset;
import elki.itemsetmining.OneItemset;
import elki.utilities.exceptions.AbortException;

public class SparseItemset
extends Itemset {
    int[] indices;

    public SparseItemset(int[] indices) {
        this.indices = indices;
    }

    public SparseItemset(int[] indices, int support) {
        this.indices = indices;
        this.support = support;
    }

    public SparseItemset(OneItemset ii, OneItemset ij) {
        int[] nArray;
        if (ii.item == ij.item) {
            throw new AbortException("SparseItemset constructed from identical 1-itemsets.");
        }
        if (ii.item < ij.item) {
            int[] nArray2 = new int[2];
            nArray2[0] = ii.item;
            nArray = nArray2;
            nArray2[1] = ij.item;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = ij.item;
            nArray = nArray3;
            nArray3[1] = ii.item;
        }
        this.indices = nArray;
    }

    @Override
    public int length() {
        return this.indices.length;
    }

    @Override
    public int iter() {
        return 0;
    }

    @Override
    public boolean iterValid(int iter) {
        return iter < this.indices.length;
    }

    @Override
    public int iterAdvance(int iter) {
        return ++iter;
    }

    @Override
    public int iterDim(int iter) {
        return this.indices[iter];
    }

    @Override
    public int compareTo(Itemset o) {
        int l2;
        int l1 = this.length();
        if (l1 < (l2 = o.length())) {
            return -1;
        }
        if (l1 > l2) {
            return 1;
        }
        if (o instanceof SparseItemset) {
            SparseItemset other = (SparseItemset)o;
            for (int i = 0; i < this.indices.length; ++i) {
                int v1 = this.indices[i];
                int v2 = other.indices[i];
                if (v1 < v2) {
                    return -1;
                }
                if (v1 <= v2) continue;
                return 1;
            }
            return 0;
        }
        return Itemset.compareLexicographical(this, o);
    }

    public boolean prefixTest(SparseItemset other) {
        if (this.indices.length != other.indices.length) {
            throw new AbortException("PrefixTest is only valid for itemsets of the same length!");
        }
        for (int k = this.indices.length - 2; k >= 0; --k) {
            if (this.indices[k] == other.indices[k]) continue;
            return false;
        }
        return true;
    }
}

