/*
 * Decompiled with CFR 0.152.
 */
package elki.logging;

import elki.logging.ELKILogRecord;
import elki.logging.LoggingConfiguration;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.progress.Progress;
import elki.logging.progress.ProgressLogRecord;
import elki.logging.progress.StepProgress;
import elki.logging.statistics.Counter;
import elki.logging.statistics.Duration;
import elki.logging.statistics.MillisTimeDuration;
import elki.logging.statistics.Statistic;
import elki.logging.statistics.UnsynchronizedLongCounter;
import java.util.HashMap;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Logging {
    private static HashMap<String, Logging> loggers;
    private final Logger logger;

    public Logging(Logger logger) {
        this.logger = logger;
    }

    public static Logging getLogger(Class<?> c) {
        return Logging.getLogger(c.getName());
    }

    public static synchronized Logging getLogger(String name) {
        Logging logger = loggers.get(name);
        if (logger == null) {
            logger = new Logging(Logger.getLogger(name));
            loggers.put(name, logger);
        }
        return logger;
    }

    public boolean isLoggable(java.util.logging.Level lev) {
        return this.logger.isLoggable(lev);
    }

    public boolean isStatistics() {
        return this.logger.isLoggable(Level.STATISTICS);
    }

    public boolean isVerbose() {
        return this.logger.isLoggable(Level.VERBOSE);
    }

    public boolean isInfo() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isVeryVerbose() {
        return this.logger.isLoggable(Level.VERYVERBOSE);
    }

    public boolean isDebugging() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isDebuggingFine() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isDebuggingFiner() {
        return this.logger.isLoggable(Level.FINER);
    }

    public boolean isDebuggingFinest() {
        return this.logger.isLoggable(Level.FINEST);
    }

    public void log(java.util.logging.Level level, CharSequence message) {
        this.logger.log(new ELKILogRecord(level, message));
    }

    public void log(java.util.logging.Level level, CharSequence message, Throwable e) {
        ELKILogRecord rec = new ELKILogRecord(level, message);
        rec.setThrown(e);
        this.logger.log(rec);
    }

    public void log(LogRecord rec) {
        this.logger.log(rec);
    }

    public void error(CharSequence message, Throwable e) {
        this.log(Level.SEVERE, message, e);
    }

    public void error(CharSequence message) {
        this.log(Level.SEVERE, message);
    }

    public void warning(CharSequence message, Throwable e) {
        this.log(Level.WARNING, message, e);
    }

    public void warning(CharSequence message) {
        this.log(Level.WARNING, message);
    }

    public void statistics(CharSequence message, Throwable e) {
        this.log(Level.STATISTICS, message, e);
    }

    public void statistics(CharSequence message) {
        if (this.logger.isLoggable(Level.STATISTICS)) {
            this.log(Level.STATISTICS, message);
        }
    }

    public void verbose(CharSequence message, Throwable e) {
        this.log(Level.INFO, message, e);
    }

    public void verbose(CharSequence message) {
        this.log(Level.INFO, message);
    }

    public void info(CharSequence message, Throwable e) {
        this.log(Level.INFO, message, e);
    }

    public void info(CharSequence message) {
        this.log(Level.INFO, message);
    }

    public void veryverbose(CharSequence message, Throwable e) {
        this.log(Level.VERYVERBOSE, message, e);
    }

    public void veryverbose(CharSequence message) {
        this.log(Level.VERYVERBOSE, message);
    }

    public void debug(CharSequence message, Throwable e) {
        this.log(Level.FINE, message, e);
    }

    public void debug(CharSequence message) {
        this.log(Level.FINE, message);
    }

    public void debugFine(CharSequence message, Throwable e) {
        this.log(Level.FINE, message, e);
    }

    public void debugFine(CharSequence message) {
        this.log(Level.FINE, message);
    }

    public void fine(CharSequence message, Throwable e) {
        this.log(Level.FINE, message, e);
    }

    public void fine(CharSequence message) {
        this.log(Level.FINE, message);
    }

    public void debugFiner(CharSequence message, Throwable e) {
        this.log(Level.FINER, message, e);
    }

    public void debugFiner(CharSequence message) {
        this.log(Level.FINER, message);
    }

    public void finer(CharSequence message, Throwable e) {
        this.log(Level.FINER, message, e);
    }

    public void finer(CharSequence message) {
        this.log(Level.FINER, message);
    }

    public void debugFinest(CharSequence message, Throwable e) {
        this.log(Level.FINEST, message, e);
    }

    public void debugFinest(CharSequence message) {
        this.log(Level.FINEST, message);
    }

    public void finest(CharSequence message, Throwable e) {
        this.log(Level.FINEST, message, e);
    }

    public void finest(CharSequence message) {
        this.log(Level.FINEST, message);
    }

    public void exception(CharSequence message, Throwable e) {
        this.log(Level.SEVERE, message, e);
    }

    public void exception(Throwable e) {
        String msg = e.getMessage();
        this.log(Level.SEVERE, msg != null ? msg : "An exception occurred.", e);
    }

    public void progress(Progress pgr) {
        this.logger.log(new ProgressLogRecord(Level.INFO, pgr));
    }

    public Counter newCounter(String key) {
        return new UnsynchronizedLongCounter(key);
    }

    public Duration newDuration(String key) {
        return new MillisTimeDuration(key);
    }

    public void incrementProcessed(AbstractProgress prog) {
        if (prog != null) {
            prog.incrementProcessed(this);
        }
    }

    public void ensureCompleted(FiniteProgress prog) {
        if (prog != null) {
            prog.ensureCompleted(this);
        }
    }

    public void beginStep(StepProgress prog, int step, String title) {
        if (prog != null) {
            prog.beginStep(step, title, this);
        }
    }

    public void setCompleted(StepProgress prog) {
        if (prog != null) {
            prog.setCompleted(this);
        }
    }

    public void setCompleted(IndefiniteProgress prog) {
        if (prog != null) {
            prog.setCompleted(this);
        }
    }

    public void statistics(Statistic stats) {
        if (stats != null) {
            this.log(Level.STATISTICS, stats.getKey() + ": " + stats.formatValue());
        }
    }

    public String toString() {
        return "Logging(" + this.logger.getName() + ", " + this.logger.getLevel() + ")";
    }

    static {
        LoggingConfiguration.assertConfigured();
        loggers = new HashMap();
    }

    public static class Level
    extends java.util.logging.Level {
        public static final Level STATISTICS = new Level("STATISTICS", INFO.intValue() + WARNING.intValue() >> 1);
        public static final java.util.logging.Level VERBOSE = INFO;
        public static final Level VERYVERBOSE = new Level("VERYVERBOSE", INFO.intValue() + CONFIG.intValue() >> 1);
        private static final long serialVersionUID = 1L;

        public Level(String name, int value) {
            super(name, value);
        }

        public static java.util.logging.Level parse(String levelName) {
            return java.util.logging.Level.parse(levelName);
        }
    }
}

