/*
 * Decompiled with CFR 0.152.
 */
package elki.logging;

import elki.logging.CLISmartHandler;
import elki.logging.Logging;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class LoggingConfiguration {
    public static boolean DEBUG = false;
    private static final String LOGGING_PROPERTIES_FILE = "logging.properties";
    public static final String TOPLEVEL_PACKAGE = "elki";
    private static final Logger LOGGER_GLOBAL_TOP = Logger.getLogger("");
    private static final Logger LOGGER_ELKI_TOP = Logger.getLogger("elki");
    private static final Logger LOGGER_TIME_TOP = Logger.getLogger("elki.workflow.AlgorithmStep");
    private static final String confbase = LoggingConfiguration.class.getPackage().getName();
    protected static LoggingConfiguration config = new LoggingConfiguration(confbase, System.getProperty("java.util.logging.config.file", "logging.properties"));

    private LoggingConfiguration(String pkg, String name) {
        this.privateReconfigureLogging(pkg, name);
    }

    public static void reconfigureLogging(String pkg, String name) {
        config.privateReconfigureLogging(pkg, name);
    }

    private void privateReconfigureLogging(String pkg, String name) {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = Logger.getLogger(LoggingConfiguration.class.getName());
        if (pkg == null) {
            pkg = "";
        }
        String cfgfile = name;
        cfgfile = new File(name).exists() ? name : pkg.replace('.', File.separatorChar) + File.separatorChar + name;
        try {
            InputStream cfgdata = LoggingConfiguration.openSystemFile(cfgfile);
            logManager.readConfiguration(cfgdata);
            InputStream cfgdata2 = LoggingConfiguration.openSystemFile(cfgfile);
            Properties cfgprop = new Properties();
            cfgprop.load(cfgdata2);
            DEBUG = Boolean.parseBoolean(cfgprop.getProperty("debug"));
            logger.info("Logging configuration read.");
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            logger.log(Logging.Level.SEVERE, "Could not find logging configuration file: " + cfgfile, e);
        }
        catch (Exception e) {
            logger.log(Logging.Level.SEVERE, "Failed to configure logging from file: " + cfgfile, e);
        }
    }

    private static InputStream openSystemFile(String filename) throws IOException {
        try {
            return Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            String resname = File.separatorChar != '/' ? filename.replace(File.separatorChar, '/') : filename;
            ClassLoader cl = LoggingConfiguration.class.getClassLoader();
            InputStream result = cl.getResourceAsStream(resname);
            if (result != null) {
                return result;
            }
            URL u = cl.getResource(resname);
            if (u == null) {
                throw e;
            }
            try {
                URLConnection conn = u.openConnection();
                conn.setUseCaches(false);
                result = conn.getInputStream();
                if (result != null) {
                    return result;
                }
            }
            catch (IOException x) {
                throw e;
            }
            throw e;
        }
    }

    public static void assertConfigured() {
    }

    public static void setVerbose(Level verbose) {
        if (verbose.intValue() <= Logging.Level.VERBOSE.intValue()) {
            if (LOGGER_GLOBAL_TOP.getLevel() == null || LOGGER_GLOBAL_TOP.getLevel().intValue() > verbose.intValue()) {
                LOGGER_GLOBAL_TOP.setLevel(verbose);
            }
            if (LOGGER_ELKI_TOP.getLevel() == null || LOGGER_ELKI_TOP.getLevel().intValue() > verbose.intValue()) {
                LOGGER_ELKI_TOP.setLevel(verbose);
            }
        } else {
            if (LOGGER_GLOBAL_TOP.getLevel() != null && (Logging.Level.VERBOSE.equals(LOGGER_GLOBAL_TOP.getLevel()) || Logging.Level.VERYVERBOSE.equals(LOGGER_GLOBAL_TOP.getLevel()))) {
                LOGGER_GLOBAL_TOP.setLevel(verbose);
            }
            if (LOGGER_ELKI_TOP.getLevel() != null && (Logging.Level.VERBOSE.equals(LOGGER_ELKI_TOP.getLevel()) || Logging.Level.VERYVERBOSE.equals(LOGGER_ELKI_TOP.getLevel()))) {
                LOGGER_ELKI_TOP.setLevel(verbose);
            }
        }
    }

    public static void setStatistics() {
        if (LOGGER_GLOBAL_TOP.getLevel() == null || LOGGER_GLOBAL_TOP.getLevel().intValue() > Logging.Level.STATISTICS.intValue()) {
            LOGGER_GLOBAL_TOP.setLevel(Logging.Level.STATISTICS);
        }
        if (LOGGER_ELKI_TOP.getLevel() == null || LOGGER_ELKI_TOP.getLevel().intValue() > Logging.Level.STATISTICS.intValue()) {
            LOGGER_ELKI_TOP.setLevel(Logging.Level.STATISTICS);
        }
        if (LOGGER_TIME_TOP.getLevel() == null || LOGGER_TIME_TOP.getLevel().intValue() > Logging.Level.STATISTICS.intValue()) {
            LOGGER_TIME_TOP.setLevel(Logging.Level.STATISTICS);
        }
    }

    public static void addHandler(Handler handler) {
        LogManager.getLogManager().getLogger("").addHandler(handler);
    }

    public static void replaceDefaultHandler(Handler handler) {
        Logger rootlogger = LogManager.getLogManager().getLogger("");
        for (Handler h : rootlogger.getHandlers()) {
            if (!(h instanceof CLISmartHandler)) continue;
            rootlogger.removeHandler(h);
        }
        LoggingConfiguration.addHandler(handler);
    }

    public static void setLevelFor(String pkg, String level) throws IllegalArgumentException {
        Logger logr = Logger.getLogger(pkg);
        if (logr == null) {
            throw new IllegalArgumentException("Logger not found.");
        }
        Level lev = Logging.Level.parse(level);
        logr.setLevel(lev);
    }

    public static void setDefaultLevel(Level level) {
        Logger.getLogger(TOPLEVEL_PACKAGE).setLevel(level);
    }
}

