/*
 * Decompiled with CFR 0.152.
 */
package elki.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class OutputStreamLogger
extends OutputStreamWriter {
    private int charsSinceNewline = 0;
    protected static final char CARRIAGE_RETURN = '\r';
    public static final char UNIX_NEWLINE = '\n';
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final char[] NEWLINEC = NEWLINE.toCharArray();
    public static final String WHITESPACE = "                                                                                ";

    public OutputStreamLogger(OutputStream out) {
        super(out);
    }

    public OutputStreamLogger(OutputStream out, String charsetName) throws UnsupportedEncodingException {
        super(out, charsetName);
    }

    public OutputStreamLogger(OutputStream out, Charset cs) {
        super(out, cs);
    }

    public OutputStreamLogger(OutputStream out, CharsetEncoder enc) {
        super(out, enc);
    }

    @Override
    public void close() {
    }

    private int tailingNonNewline(char[] cbuf, int off, int len) {
        for (int cnt = 0; cnt < len; ++cnt) {
            int pos = off + (len - 1) - cnt;
            if (cbuf[pos] == '\n') {
                return cnt;
            }
            if (cbuf[pos] != '\r') continue;
            return cnt;
        }
        return len;
    }

    private int tailingNonNewline(String str, int off, int len) {
        for (int cnt = 0; cnt < len; ++cnt) {
            int pos = off + (len - 1) - cnt;
            if (str.charAt(pos) == '\n') {
                return cnt;
            }
            if (str.charAt(pos) != '\r') continue;
            return cnt;
        }
        return len;
    }

    private int countNonNewline(char[] cbuf, int off, int len) {
        for (int cnt = 0; cnt < len; ++cnt) {
            int pos = off + cnt;
            if (cbuf[pos] == '\n') {
                return cnt;
            }
            if (cbuf[pos] != '\r') continue;
            return cnt;
        }
        return len;
    }

    private int countNonNewline(String str, int off, int len) {
        for (int cnt = 0; cnt < len; ++cnt) {
            int pos = off + cnt;
            if (str.charAt(pos) == '\n') {
                return cnt;
            }
            if (str.charAt(pos) != '\r') continue;
            return cnt;
        }
        return len;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        if (this.charsSinceNewline > 0) {
            if (cbuf[off] != '\r') {
                super.write(NEWLINEC, 0, NEWLINEC.length);
                this.charsSinceNewline = 0;
            } else {
                int nonnl = this.countNonNewline(cbuf, off + 1, len - 1);
                if (nonnl < this.charsSinceNewline) {
                    super.write(13);
                    while (this.charsSinceNewline > 0) {
                        int n = Math.min(this.charsSinceNewline, WHITESPACE.length());
                        super.write(WHITESPACE, 0, n);
                        this.charsSinceNewline -= n;
                    }
                } else {
                    this.charsSinceNewline = 0;
                }
            }
        }
        this.charsSinceNewline = this.tailingNonNewline(cbuf, off, len);
        super.write(cbuf, off, len);
        this.flush();
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        if (this.charsSinceNewline > 0) {
            if (str.charAt(off) != '\r') {
                super.write(NEWLINEC, 0, NEWLINEC.length);
                this.charsSinceNewline = 0;
            } else {
                int nonnl = this.countNonNewline(str, off + 1, len - 1);
                if (nonnl < this.charsSinceNewline) {
                    super.write(13);
                    while (this.charsSinceNewline > 0) {
                        int n = Math.min(this.charsSinceNewline, WHITESPACE.length());
                        super.write(WHITESPACE, 0, n);
                        this.charsSinceNewline -= n;
                    }
                } else {
                    this.charsSinceNewline = 0;
                }
            }
        }
        this.charsSinceNewline = this.tailingNonNewline(str, off, len);
        super.write(str, off, len);
        this.flush();
    }
}

