/*
 * Decompiled with CFR 0.152.
 */
package elki.logging.progress;

import elki.logging.Logging;
import elki.logging.progress.Progress;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractProgress
implements Progress {
    private AtomicInteger processed = new AtomicInteger(0);
    private String task;
    private long lastLogged = 0L;
    private int lastValue = 0;
    protected double ratems = Double.NaN;

    public AbstractProgress(String task) {
        this.task = task;
    }

    public String getTask() {
        return this.task;
    }

    protected void setProcessed(int processed) throws IllegalArgumentException {
        this.processed.set(processed);
    }

    public void setProcessed(int processed, Logging logger) throws IllegalArgumentException {
        this.setProcessed(processed);
        if (this.testLoggingRate(processed)) {
            logger.progress(this);
        }
    }

    public int getProcessed() {
        return this.processed.get();
    }

    @Override
    public abstract StringBuilder appendToBuffer(StringBuilder var1);

    @Override
    public String toString() {
        return this.appendToBuffer(new StringBuilder(200)).toString();
    }

    public void incrementProcessed(Logging logger) {
        if (this.testLoggingRate(this.processed.incrementAndGet())) {
            logger.progress(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean testLoggingRate(int processed) {
        long now = System.currentTimeMillis();
        if (processed > 10 && (double)(now - this.lastLogged) < 500.0) {
            return this.isComplete();
        }
        AbstractProgress abstractProgress = this;
        synchronized (abstractProgress) {
            long age = now - this.lastLogged;
            if ((double)age < 500.0) {
                return this.isComplete();
            }
            if (this.lastValue > 0) {
                int increment = processed - this.lastValue;
                double newrate = (double)increment / (double)age;
                this.ratems = this.ratems != this.ratems ? newrate : 0.95 * this.ratems + 0.05 * newrate;
            }
            this.lastValue = processed;
            this.lastLogged = now;
        }
        return true;
    }
}

