/*
 * Decompiled with CFR 0.152.
 */
package elki.logging.progress;

import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;

public class FiniteProgress
extends AbstractProgress {
    private final int total;
    private final int totalLength;

    protected FiniteProgress(String task, int total) {
        super(task);
        this.total = total;
        this.totalLength = this.numDigits(total);
    }

    public FiniteProgress(String task, int total, Logging logger) {
        super(task);
        this.total = total;
        this.totalLength = this.numDigits(total);
        logger.progress(this);
    }

    @Override
    protected void setProcessed(int processed) throws IllegalArgumentException {
        if (processed > this.total) {
            throw new IllegalArgumentException(processed + " exceeds total: " + this.total);
        }
        if (processed < 0) {
            throw new IllegalArgumentException("Negative number of processed: " + processed);
        }
        super.setProcessed(processed);
    }

    @Override
    public StringBuilder appendToBuffer(StringBuilder buf) {
        int p = this.getProcessed();
        buf.append(this.getTask()).append(": ");
        int l = this.totalLength - this.numDigits(p);
        for (int i = 0; i < l; ++i) {
            buf.append(' ');
        }
        int percentage = (int)((double)p * 100.0 / (double)this.total);
        buf.append(p).append(" [").append(percentage < 10 ? "  " : (percentage < 100 ? " " : "")).append(percentage).append("%]");
        if (this.ratems > 0.0 && p < this.total) {
            int secs = (int)Math.round((double)(this.total - p) / this.ratems / 1000.0 + 0.2);
            if (secs > 300) {
                buf.append(' ').append(secs / 60).append(" min remaining");
            } else {
                buf.append(' ').append(secs).append(" sec remaining");
            }
        }
        return buf;
    }

    private int numDigits(int x) {
        return x == Integer.MIN_VALUE ? 10 : (x < 0 ? 1 + this.numDigits(-x) : (x < 10000 ? (x < 100 ? (x < 10 ? 1 : 2) : (x < 1000 ? 3 : 4)) : (x < 100000000 ? (x < 1000000 ? (x < 100000 ? 5 : 6) : (x < 10000000 ? 7 : 8)) : (x < 1000000000 ? 9 : 10))));
    }

    @Override
    public boolean isComplete() {
        return this.getProcessed() == this.total;
    }

    public int getTotal() {
        return this.total;
    }

    public void ensureCompleted(Logging logger) {
        if (!this.isComplete()) {
            logger.warning("Progress had not completed automatically as expected: " + this.getProcessed() + "/" + this.total, new Throwable());
            this.setProcessed(this.getTotal());
            logger.progress(this);
        }
    }
}

