/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.outlier;

import elki.database.Database;
import elki.database.DatabaseUtil;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.evaluation.Evaluator;
import elki.math.linearalgebra.VMath;
import elki.result.HistogramResult;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.result.outlier.OutlierResult;
import elki.utilities.datastructures.histogram.AbstractObjDynamicHistogram;
import elki.utilities.datastructures.histogram.ObjHistogram;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.PatternParameter;
import elki.utilities.scaling.IdentityScaling;
import elki.utilities.scaling.ScalingFunction;
import elki.utilities.scaling.outlier.OutlierScaling;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class ComputeOutlierHistogram
implements Evaluator {
    private Pattern positiveClassName = null;
    private int bins;
    private ScalingFunction scaling;
    private boolean splitfreq = false;

    public ComputeOutlierHistogram(Pattern positive_class_name, int bins, ScalingFunction scaling, boolean splitfreq) {
        this.positiveClassName = positive_class_name;
        this.bins = bins;
        this.scaling = scaling;
        this.splitfreq = splitfreq;
    }

    public HistogramResult evaluateOutlierResult(Database database, OutlierResult or) {
        double result;
        double negative;
        if (this.scaling instanceof OutlierScaling) {
            ((OutlierScaling)this.scaling).prepare(or);
        }
        HashSetModifiableDBIDs ids = DBIDUtil.newHashSet((DBIDs)or.getScores().getDBIDs());
        ArrayModifiableDBIDs outlierIds = DatabaseUtil.getObjectsByLabelMatch((Database)database, (Pattern)this.positiveClassName);
        double min = this.scaling.getMin();
        double max = this.scaling.getMax();
        Object hist = Double.isInfinite(min) || Double.isNaN(min) || Double.isInfinite(max) || Double.isNaN(max) ? new AbstractObjDynamicHistogram<double[]>(this.bins){

            public double[] aggregate(double[] first, double[] second) {
                return VMath.plusEquals((double[])first, (double[])second);
            }

            protected double[] makeObject() {
                return new double[2];
            }

            protected double[] cloneForCache(double[] data) {
                return (double[])data.clone();
            }

            protected double[] downsample(Object[] data, int start, int end, int size) {
                double[] sum = new double[2];
                for (int i = start; i < end; ++i) {
                    Object p = data[i];
                    if (p == null) continue;
                    VMath.plusEquals((double[])sum, (double[])((double[])p));
                }
                return sum;
            }
        } : new ObjHistogram(this.bins, min, max, () -> new double[2]);
        double positive = negative = 1.0 / (double)ids.size();
        if (this.splitfreq) {
            negative = 1.0 / (double)(ids.size() - outlierIds.size());
            positive = 1.0 / (double)outlierIds.size();
        }
        ids.removeDBIDs((DBIDs)outlierIds);
        DBIDMIter iter = ids.iter();
        while (iter.valid()) {
            result = or.getScores().doubleValue((DBIDRef)iter);
            if ((result = this.scaling.getScaled(result)) > Double.NEGATIVE_INFINITY && result < Double.POSITIVE_INFINITY) {
                double[] dArray = (double[])hist.get(result);
                dArray[0] = dArray[0] + negative;
            }
            iter.advance();
        }
        iter = outlierIds.iter();
        while (iter.valid()) {
            result = or.getScores().doubleValue((DBIDRef)iter);
            if ((result = this.scaling.getScaled(result)) > Double.NEGATIVE_INFINITY && result < Double.POSITIVE_INFINITY) {
                double[] dArray = (double[])hist.get(result);
                dArray[1] = dArray[1] + positive;
            }
            iter.advance();
        }
        ArrayList<double[]> collHist = new ArrayList<double[]>(hist.getNumBins());
        ObjHistogram.Iter iter2 = hist.iter();
        while (iter2.valid()) {
            double[] data = (double[])iter2.getValue();
            collHist.add(new double[]{iter2.getCenter(), data[0], data[1]});
            iter2.advance();
        }
        HistogramResult result2 = new HistogramResult(collHist);
        Metadata.of((Object)result2).setLongName("Outlier Score Histogram");
        return result2;
    }

    public void processNewResult(Object result) {
        Database db = ResultUtil.findDatabase((Object)result);
        ArrayList ors = ResultUtil.filterResults((Object)result, OutlierResult.class);
        if (ors == null || ors.isEmpty()) {
            return;
        }
        for (OutlierResult or : ors) {
            Metadata.hierarchyOf((Object)or).addChild((Object)this.evaluateOutlierResult(db, or));
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("comphist.positive", "Class label for the 'positive' class.");
        public static final OptionID BINS_ID = new OptionID("comphist.bins", "number of bins");
        public static final OptionID SCALING_ID = new OptionID("comphist.scaling", "Class to use as scaling function.");
        public static final OptionID SPLITFREQ_ID = new OptionID("histogram.splitfreq", "Use separate frequencies for outliers and non-outliers.");
        protected Pattern positiveClassName = null;
        protected int bins;
        protected ScalingFunction scaling;
        protected boolean splitfreq = false;

        public void configure(Parameterization config) {
            ((PatternParameter)new PatternParameter(POSITIVE_CLASS_NAME_ID).setOptional(true)).grab(config, x -> {
                this.positiveClassName = x;
            });
            ((IntParameter)new IntParameter(BINS_ID, 50).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.bins = x;
            });
            new ObjectParameter(SCALING_ID, ScalingFunction.class, IdentityScaling.class).grab(config, x -> {
                this.scaling = x;
            });
            new Flag(SPLITFREQ_ID).grab(config, x -> {
                this.splitfreq = x;
            });
        }

        public ComputeOutlierHistogram make() {
            return new ComputeOutlierHistogram(this.positiveClassName, this.bins, this.scaling, this.splitfreq);
        }
    }
}

