/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.outlier;

import elki.database.Database;
import elki.database.DatabaseUtil;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.evaluation.Evaluator;
import elki.logging.Logging;
import elki.result.CollectionResult;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.result.outlier.OutlierResult;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.PatternParameter;
import elki.utilities.scaling.IdentityScaling;
import elki.utilities.scaling.LinearScaling;
import elki.utilities.scaling.ScalingFunction;
import elki.utilities.scaling.outlier.OutlierScaling;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;

public class JudgeOutlierScores
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(JudgeOutlierScores.class);
    private Pattern positiveClassName;
    private ScalingFunction scaling;

    public JudgeOutlierScores(Pattern positive_class_name, ScalingFunction scaling) {
        this.positiveClassName = positive_class_name;
        this.scaling = scaling;
    }

    protected ScoreResult computeScore(DBIDs ids, DBIDs outlierIds, OutlierResult or) {
        double result;
        IdentityScaling innerScaling;
        if (this.scaling instanceof OutlierScaling) {
            ((OutlierScaling)this.scaling).prepare(or);
        }
        double min = this.scaling.getMin();
        double max = this.scaling.getMax();
        if (Double.isInfinite(min) || Double.isNaN(min) || Double.isInfinite(max) || Double.isNaN(max)) {
            innerScaling = new IdentityScaling();
            LOG.warning((CharSequence)("JudgeOutlierScores expects values between 0.0 and 1.0, but we don't have such a guarantee by the scaling function: min:" + min + " max:" + max));
        } else {
            innerScaling = min == 0.0 && max == 1.0 ? new IdentityScaling() : new LinearScaling(1.0 / (max - min), -min);
        }
        double posscore = 0.0;
        double negscore = 0.0;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            result = or.getScores().doubleValue((DBIDRef)iter);
            result = innerScaling.getScaled(this.scaling.getScaled(result));
            posscore += 1.0 - result;
            iter.advance();
        }
        iter = outlierIds.iter();
        while (iter.valid()) {
            result = or.getScores().doubleValue((DBIDRef)iter);
            result = innerScaling.getScaled(this.scaling.getScaled(result));
            negscore += result;
            iter.advance();
        }
        LOG.verbose((CharSequence)("Scores: " + (posscore /= (double)ids.size()) + " " + (negscore /= (double)outlierIds.size())));
        ArrayList<double[]> s = new ArrayList<double[]>(1);
        s.add(new double[]{(posscore + negscore) * 0.5, posscore, negscore});
        return new ScoreResult(s);
    }

    public void processNewResult(Object result) {
        Database db = ResultUtil.findDatabase((Object)result);
        ArrayList ors = ResultUtil.filterResults((Object)result, OutlierResult.class);
        if (ors == null || ors.isEmpty()) {
            return;
        }
        HashSetModifiableDBIDs ids = DBIDUtil.newHashSet((DBIDs)((OutlierResult)ors.iterator().next()).getScores().getDBIDs());
        ArrayModifiableDBIDs outlierIds = DatabaseUtil.getObjectsByLabelMatch((Database)db, (Pattern)this.positiveClassName);
        ids.removeDBIDs((DBIDs)outlierIds);
        for (OutlierResult or : ors) {
            Metadata.hierarchyOf((Object)or).addChild((Object)this.computeScore((DBIDs)ids, (DBIDs)outlierIds, or));
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("comphist.positive", "Class label for the 'positive' class.");
        public static final OptionID SCALING_ID = new OptionID("comphist.scaling", "Class to use as scaling function.");
        private Pattern positiveClassName;
        private ScalingFunction scaling;

        public void configure(Parameterization config) {
            new PatternParameter(POSITIVE_CLASS_NAME_ID).grab(config, x -> {
                this.positiveClassName = x;
            });
            new ObjectParameter(SCALING_ID, ScalingFunction.class, IdentityScaling.class).grab(config, x -> {
                this.scaling = x;
            });
        }

        public JudgeOutlierScores make() {
            return new JudgeOutlierScores(this.positiveClassName, this.scaling);
        }
    }

    public static class ScoreResult
    extends CollectionResult<double[]> {
        public ScoreResult(Collection<double[]> col) {
            super(col);
            Metadata.of((Object)((Object)this)).setLongName("Outlier Score");
        }
    }
}

