/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.outlier;

import elki.database.Database;
import elki.database.DatabaseUtil;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.SetDBIDs;
import elki.evaluation.Evaluator;
import elki.evaluation.scores.AUPRCEvaluation;
import elki.evaluation.scores.ScoreEvaluation;
import elki.evaluation.scores.adapter.OutlierScoreAdapter;
import elki.evaluation.scores.adapter.SimpleAdapter;
import elki.logging.Logging;
import elki.result.EvaluationResult;
import elki.result.Metadata;
import elki.result.OrderingResult;
import elki.result.ResultUtil;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.regex.Pattern;

@Reference(authors="J. Davis and M. Goadrich", title="The relationship between Precision-Recall and ROC curves", booktitle="Proc. 23rd Int. Conf. Machine Learning (ICML)", url="https://doi.org/10.1145/1143844.1143874", bibkey="DBLP:conf/icml/DavisG06")
public class OutlierPrecisionRecallCurve
implements Evaluator {
    public static final String PRAUC_LABEL = "AUPRC";
    private static final Logging LOG = Logging.getLogger(OutlierPrecisionRecallCurve.class);
    private Pattern positiveClassName;

    public OutlierPrecisionRecallCurve(Pattern positiveClassName) {
        this.positiveClassName = positiveClassName;
    }

    public void processNewResult(Object result) {
        SetDBIDs positiveids = DBIDUtil.ensureSet((DBIDs)DatabaseUtil.getObjectsByLabelMatch((Database)ResultUtil.findDatabase((Object)result), (Pattern)this.positiveClassName));
        if (positiveids.size() == 0) {
            LOG.warning((CharSequence)"Computing a P/R curve failed - no objects matched.");
            return;
        }
        List<OutlierResult> oresults = OutlierResult.getOutlierResults(result);
        List orderings = ResultUtil.getOrderingResults((Object)result);
        for (OutlierResult o : oresults) {
            AUPRCEvaluation.PRCurve curve = AUPRCEvaluation.materializePRC((ScoreEvaluation.Adapter)new OutlierScoreAdapter((DBIDs)positiveids, o));
            Metadata.hierarchyOf((Object)o).addChild((Object)curve);
            EvaluationResult.MeasurementGroup g = EvaluationResult.findOrCreate((Object)o, (String)"Evaluation of Ranking").findOrCreateGroup("Evaluation measures");
            if (!g.hasMeasure(PRAUC_LABEL)) {
                g.addMeasure(PRAUC_LABEL, curve.getAUC(), 0.0, 1.0, false);
            }
            orderings.remove(o.getOrdering());
        }
        for (OrderingResult or : orderings) {
            ArrayModifiableDBIDs sorted = or.order(or.getDBIDs());
            AUPRCEvaluation.PRCurve curve = AUPRCEvaluation.materializePRC((ScoreEvaluation.Adapter)new SimpleAdapter((DBIDs)positiveids, sorted.iter(), sorted.size()));
            Metadata.hierarchyOf((Object)or).addChild((Object)curve);
            EvaluationResult.MeasurementGroup g = EvaluationResult.findOrCreate((Object)or, (String)"Evaluation of Ranking").findOrCreateGroup("Evaluation measures");
            if (g.hasMeasure(PRAUC_LABEL)) continue;
            g.addMeasure(PRAUC_LABEL, curve.getAUC(), 0.0, 1.0, false);
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("precision.positive", "Class label for the 'positive' class.");
        protected Pattern positiveClassName = null;

        public void configure(Parameterization config) {
            new PatternParameter(POSITIVE_CLASS_NAME_ID).grab(config, x -> {
                this.positiveClassName = x;
            });
        }

        public OutlierPrecisionRecallCurve make() {
            return new OutlierPrecisionRecallCurve(this.positiveClassName);
        }
    }
}

