/*
 * Decompiled with CFR 0.152.
 */
package elki.evaluation.outlier;

import elki.database.Database;
import elki.database.DatabaseUtil;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.SetDBIDs;
import elki.evaluation.Evaluator;
import elki.evaluation.scores.AUPRCEvaluation;
import elki.evaluation.scores.AveragePrecisionEvaluation;
import elki.evaluation.scores.DCGEvaluation;
import elki.evaluation.scores.MaximumF1Evaluation;
import elki.evaluation.scores.NDCGEvaluation;
import elki.evaluation.scores.PRGCEvaluation;
import elki.evaluation.scores.PrecisionAtKEvaluation;
import elki.evaluation.scores.ROCEvaluation;
import elki.evaluation.scores.ScoreEvaluation;
import elki.evaluation.scores.adapter.OutlierScoreAdapter;
import elki.evaluation.scores.adapter.SimpleAdapter;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Statistic;
import elki.result.EvaluationResult;
import elki.result.OrderingResult;
import elki.result.ResultUtil;
import elki.result.outlier.OutlierResult;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class OutlierRankingEvaluation
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(OutlierRankingEvaluation.class);
    private Pattern positiveClassName;
    private String key = OutlierRankingEvaluation.class.getName();

    public OutlierRankingEvaluation(Pattern positive_class_name) {
        this.positiveClassName = positive_class_name;
    }

    private void evaluate(EvaluationResult res, int size, int pos, Supplier<ScoreEvaluation.Adapter> adapter) {
        double rate = (double)pos / (double)size;
        EvaluationResult.MeasurementGroup g = res.findOrCreateGroup("Evaluation measures");
        EvaluationResult.MeasurementGroup ag = res.findOrCreateGroup("Adjusted for chance");
        double auroc = ROCEvaluation.STATIC.evaluate(adapter.get());
        LOG.statistics((Statistic)new DoubleStatistic(this.key + ".auroc", auroc));
        g.addMeasure("AUROC", auroc, 0.0, 1.0, 0.5, false);
        double adjauroc = 2.0 * auroc - 1.0;
        ag.addMeasure("Adjusted AUROC", adjauroc, 0.0, 1.0, 0.0, false);
        LOG.statistics((Statistic)new DoubleStatistic(this.key + ".auroc.adjusted", adjauroc));
        double auprc = AUPRCEvaluation.STATIC.evaluate(adapter.get());
        LOG.statistics((Statistic)new DoubleStatistic(this.key + ".auprc", auprc));
        g.addMeasure("AUPRC", auprc, 0.0, 1.0, rate, false);
        double adjauprc = (auprc - rate) / (1.0 - rate);
        LOG.statistics((Statistic)new DoubleStatistic(this.key + ".auprc.adjusted", adjauprc));
        ag.addMeasure("Adjusted AUPRC", adjauprc, 0.0, 1.0, 0.0, false);
        double auprgc = PRGCEvaluation.STATIC.evaluate(adapter.get());
        LOG.statistics((Statistic)new DoubleStatistic(this.key + ".auprgc", auprgc));
        g.addMeasure("AUPRGC", auprgc, 0.0, 1.0, 0.5, false);
        ag.addMeasure("Adjusted AUPRGC", (auprgc - 0.5) * 2.0, 0.0, 1.0, 0.0, false);
        double avep = AveragePrecisionEvaluation.STATIC.evaluate(adapter.get());
        LOG.statistics((Statistic)new DoubleStatistic(this.key + ".average-precision.", avep));
        g.addMeasure("Average Precision", avep, 0.0, 1.0, rate, false);
        double adjavep = (avep - rate) / (1.0 - rate);
        LOG.statistics((Statistic)new DoubleStatistic(this.key + ".average-precision.adjusted", adjavep));
        ag.addMeasure("Adjusted AveP", adjavep, 0.0, 1.0, 0.0, false);
        double rprec = PrecisionAtKEvaluation.RPRECISION.evaluate(adapter.get());
        LOG.statistics((Statistic)new DoubleStatistic(this.key + ".r-precision", rprec));
        g.addMeasure("R-Precision", rprec, 0.0, 1.0, rate, false);
        double adjrprec = (rprec - rate) / (1.0 - rate);
        LOG.statistics((Statistic)new DoubleStatistic(this.key + ".r-precision.adjusted", adjrprec));
        ag.addMeasure("Adjusted R-Prec", adjrprec, 0.0, 1.0, 0.0, false);
        double maxf1 = MaximumF1Evaluation.STATIC.evaluate(adapter.get());
        LOG.statistics((Statistic)new DoubleStatistic(this.key + ".maximum-f1", maxf1));
        g.addMeasure("Maximum F1", maxf1, 0.0, 1.0, rate, false);
        double adjmaxf1 = (maxf1 - rate) / (1.0 - rate);
        LOG.statistics((Statistic)new DoubleStatistic(this.key + ".maximum-f1.adjusted", adjmaxf1));
        ag.addMeasure("Adjusted Max F1", adjmaxf1, 0.0, 1.0, 0.0, false);
        double maxdcg = DCGEvaluation.maximum((int)pos);
        double dcg = DCGEvaluation.STATIC.evaluate(adapter.get());
        LOG.statistics((Statistic)new DoubleStatistic(this.key + ".dcg", dcg));
        g.addMeasure("DCG", dcg, 0.0, maxdcg, DCGEvaluation.STATIC.expected(pos, size), false);
        double ndcg = NDCGEvaluation.STATIC.evaluate(adapter.get());
        LOG.statistics((Statistic)new DoubleStatistic(this.key + ".dcg.normalized", ndcg));
        g.addMeasure("NDCG", ndcg, 0.0, 1.0, NDCGEvaluation.STATIC.expected(pos, size), false);
        double endcg = NDCGEvaluation.STATIC.expected(pos, size);
        double adjndcg = (ndcg - endcg) / (1.0 - endcg);
        LOG.statistics((Statistic)new DoubleStatistic(this.key + ".dcg.adjusted", adjndcg));
        ag.addMeasure("Adjusted DCG", adjndcg, 0.0, 1.0, 0.0, false);
    }

    public void processNewResult(Object result) {
        Database db = ResultUtil.findDatabase((Object)result);
        SetDBIDs positiveids = DBIDUtil.ensureSet((DBIDs)DatabaseUtil.getObjectsByLabelMatch((Database)db, (Pattern)this.positiveClassName));
        if (positiveids.size() == 0) {
            LOG.warning((CharSequence)"Cannot evaluate outlier results - no objects matched the given pattern.");
            return;
        }
        boolean nonefound = true;
        List<OutlierResult> oresults = OutlierResult.getOutlierResults(result);
        List orderings = ResultUtil.getOrderingResults((Object)result);
        for (OutlierResult o : oresults) {
            this.evaluate(EvaluationResult.findOrCreate((Object)o, (String)"Evaluation of Ranking"), o.getScores().size(), positiveids.size(), () -> new OutlierScoreAdapter((DBIDs)positiveids, o));
            orderings.remove(o.getOrdering());
            nonefound = false;
        }
        for (OrderingResult or : orderings) {
            ArrayModifiableDBIDs sorted = or.order(or.getDBIDs());
            int size = or.getDBIDs().size();
            if (sorted.size() != size) {
                throw new IllegalStateException("Iterable result doesn't match database size - incomplete ordering?");
            }
            this.evaluate(EvaluationResult.findOrCreate((Object)or, (String)"Evaluation of Ranking"), size, positiveids.size(), () -> OutlierRankingEvaluation.lambda$processNewResult$1(positiveids, (DBIDs)sorted));
            nonefound = false;
        }
        if (nonefound) {
            // empty if block
        }
    }

    private static /* synthetic */ ScoreEvaluation.Adapter lambda$processNewResult$1(SetDBIDs positiveids, DBIDs sorted) {
        return new SimpleAdapter((DBIDs)positiveids, sorted.iter(), sorted.size());
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("outliereval.positive", "Class label for the 'positive' class.");
        protected Pattern positiveClassName = null;

        public void configure(Parameterization config) {
            new PatternParameter(POSITIVE_CLASS_NAME_ID).grab(config, x -> {
                this.positiveClassName = x;
            });
        }

        public OutlierRankingEvaluation make() {
            return new OutlierRankingEvaluation(this.positiveClassName);
        }
    }
}

