/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.math.DoubleMinMax;
import elki.math.MathUtil;
import elki.math.linearalgebra.CovarianceMatrix;
import elki.math.linearalgebra.LUDecomposition;
import elki.math.linearalgebra.VMath;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.InvertedOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import net.jafama.FastMath;

@Title(value="Gaussian Model Outlier Detection")
@Description(value="Fit a multivariate gaussian model onto the data, and use the PDF to compute an outlier score.")
public class GaussianModel
implements OutlierAlgorithm {
    private boolean invert = false;

    public GaussianModel(boolean invert) {
        this.invert = invert;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public OutlierResult run(Relation<? extends NumberVector> relation) {
        BasicOutlierScoreMeta meta;
        DoubleMinMax mm = new DoubleMinMax();
        WritableDoubleDataStore oscores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)3);
        CovarianceMatrix temp = CovarianceMatrix.make(relation);
        double[] mean = temp.getMeanVector(relation).toArray();
        double[][] covarianceMatrix = temp.destroyToPopulationMatrix();
        double[][] covarianceTransposed = VMath.inverse((double[][])covarianceMatrix);
        double det = new LUDecomposition(covarianceMatrix).det();
        double fakt = 1.0 / Math.sqrt(MathUtil.powi((double)(Math.PI * 2), (int)RelationUtil.dimensionality(relation)) * det);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double[] x = VMath.minusEquals((double[])((NumberVector)relation.get((DBIDRef)iditer)).toArray(), (double[])mean);
            double mDist = VMath.transposeTimesTimes((double[])x, (double[][])covarianceTransposed, (double[])x);
            double prob = fakt * FastMath.exp((double)(-mDist * 0.5));
            mm.put(prob);
            oscores.putDouble((DBIDRef)iditer, prob);
            iditer.advance();
        }
        if (this.invert) {
            double max = mm.getMax() != 0.0 ? mm.getMax() : 1.0;
            DBIDIter iditer2 = relation.iterDBIDs();
            while (iditer2.valid()) {
                oscores.putDouble((DBIDRef)iditer2, (max - oscores.doubleValue((DBIDRef)iditer2)) / max);
                iditer2.advance();
            }
            meta = new BasicOutlierScoreMeta(0.0, 1.0);
        } else {
            meta = new InvertedOutlierScoreMeta(mm.getMin(), mm.getMax(), 0.0, Double.POSITIVE_INFINITY);
        }
        MaterializedDoubleRelation res = new MaterializedDoubleRelation("Gaussian Model Outlier Score", relation.getDBIDs(), (DoubleDataStore)oscores);
        return new OutlierResult(meta, (DoubleRelation)res);
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID INVERT_ID = new OptionID("gaussod.invert", "Invert the value range to [0:1], with 1 being outliers instead of 0.");
        protected boolean invert = false;

        public void configure(Parameterization config) {
            new Flag(INVERT_ID).grab(config, x -> {
                this.invert = x;
            });
        }

        public GaussianModel make() {
            return new GaussianModel(this.invert);
        }
    }
}

