/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.anglebased;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.similarity.SimilarityQuery;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.math.DoubleMinMax;
import elki.math.MeanVariance;
import elki.outlier.anglebased.ABOD;
import elki.result.outlier.InvertedOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.similarity.Similarity;
import elki.similarity.kernel.KernelMatrix;
import elki.similarity.kernel.LinearKernel;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.GreaterEqualConstraint;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="Approximate ABOD: Angle-Based Outlier Detection")
@Description(value="Outlier detection using variance analysis on angles, especially for high dimensional data sets.")
@Reference(authors="Hans-Peter Kriegel, Matthias Schubert, Arthur Zimek", title="Angle-Based Outlier Detection in High-dimensional Data", booktitle="Proc. 14th ACM SIGKDD Int. Conf. Knowledge Discovery and Data Mining (KDD'08)", url="https://doi.org/10.1145/1401890.1401946", bibkey="DBLP:conf/kdd/KriegelSZ08")
public class FastABOD<V extends NumberVector>
extends ABOD<V> {
    protected int k;

    public FastABOD(Similarity<? super V> kernelFunction, int k) {
        super(kernelFunction);
        this.k = k;
    }

    @Override
    public OutlierResult run(Relation<V> relation) {
        DBIDs ids = relation.getDBIDs();
        WritableDoubleDataStore abodvalues = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)4);
        DoubleMinMax minmaxabod = new DoubleMinMax();
        if (this.kernelFunction.getClass() == LinearKernel.class) {
            if (!this.kNNABOD(relation, ids, abodvalues, minmaxabod)) {
                this.fastABOD(relation, ids, abodvalues, minmaxabod);
            }
        } else {
            this.fastABOD(relation, ids, abodvalues, minmaxabod);
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Angle-Based Outlier Degree", relation.getDBIDs(), (DoubleDataStore)abodvalues);
        InvertedOutlierScoreMeta scoreMeta = new InvertedOutlierScoreMeta(minmaxabod.getMin(), minmaxabod.getMax(), 0.0, Double.POSITIVE_INFINITY);
        return new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
    }

    private boolean kNNABOD(Relation<V> relation, DBIDs ids, WritableDoubleDataStore abodvalues, DoubleMinMax minmaxabod) {
        int k1 = this.k + 1;
        DistanceQuery dq = new QueryBuilder(relation, (Distance)SquaredEuclideanDistance.STATIC).distanceQuery();
        KNNSearcher knnq = new QueryBuilder(dq).optimizedOnly().kNNByDBID(k1);
        boolean squared = true;
        if (knnq == null) {
            dq = new QueryBuilder(relation, (Distance)EuclideanDistance.STATIC).distanceQuery();
            knnq = new QueryBuilder(dq).optimizedOnly().kNNByDBID(k1);
            if (knnq == null) {
                return false;
            }
            squared = false;
        }
        SimilarityQuery lk = new QueryBuilder(relation, (Similarity)LinearKernel.STATIC).similarityQuery();
        MeanVariance s = new MeanVariance();
        DBIDIter pA = ids.iter();
        while (pA.valid()) {
            KNNList nl = knnq.getKNN((Object)pA, k1);
            double simAA = lk.similarity((DBIDRef)pA, (DBIDRef)pA);
            s.reset();
            DoubleDBIDListIter iB = nl.iter();
            DoubleDBIDListIter iC = nl.iter();
            while (iB.valid()) {
                double dAB = iB.doubleValue();
                double simAB = lk.similarity((DBIDRef)pA, (DBIDRef)iB);
                if (dAB > 0.0) {
                    iC.seek(iB.getOffset() + 1);
                    while (iC.valid()) {
                        double dAC = iC.doubleValue();
                        double simAC = lk.similarity((DBIDRef)pA, (DBIDRef)iC);
                        if (dAC > 0.0) {
                            double simBC = lk.similarity((DBIDRef)iB, (DBIDRef)iC);
                            double numerator = simBC - simAB - simAC + simAA;
                            if (squared) {
                                double div = 1.0 / (dAB * dAC);
                                s.put(numerator * div, Math.sqrt(div));
                            } else {
                                double sqrtdiv = 1.0 / (dAB * dAC);
                                s.put(numerator * sqrtdiv * sqrtdiv, sqrtdiv);
                            }
                        }
                        iC.advance();
                    }
                }
                iB.advance();
            }
            double abof = s.getCount() > 0.0 ? s.getPopulationVariance() : Double.POSITIVE_INFINITY;
            minmaxabod.put(abof);
            abodvalues.putDouble((DBIDRef)pA, abof);
            pA.advance();
        }
        return true;
    }

    private void fastABOD(Relation<V> relation, DBIDs ids, WritableDoubleDataStore abodvalues, DoubleMinMax minmaxabod) {
        SimilarityQuery sq = new QueryBuilder(relation, this.kernelFunction).similarityQuery();
        KernelMatrix kernelMatrix = new KernelMatrix(sq, relation, ids);
        MeanVariance s = new MeanVariance();
        KNNHeap nn = DBIDUtil.newHeap((int)this.k);
        DBIDIter pA = ids.iter();
        while (pA.valid()) {
            double simAA = kernelMatrix.getSimilarity((DBIDRef)pA, (DBIDRef)pA);
            nn.clear();
            DBIDIter nB = relation.iterDBIDs();
            while (nB.valid()) {
                double simAB;
                double simBB;
                double sqdAB;
                if (!DBIDUtil.equal((DBIDRef)nB, (DBIDRef)pA) && (sqdAB = simAA + (simBB = kernelMatrix.getSimilarity((DBIDRef)nB, (DBIDRef)nB)) - (simAB = kernelMatrix.getSimilarity((DBIDRef)pA, (DBIDRef)nB)) - simAB) > 0.0) {
                    nn.insert(sqdAB, (DBIDRef)nB);
                }
                nB.advance();
            }
            KNNList nl = nn.toKNNList();
            s.reset();
            DoubleDBIDListIter iB = nl.iter();
            DoubleDBIDListIter iC = nl.iter();
            while (iB.valid()) {
                double sqdAB = iB.doubleValue();
                double simAB = kernelMatrix.getSimilarity((DBIDRef)pA, (DBIDRef)iB);
                if (sqdAB > 0.0) {
                    iC.seek(iB.getOffset() + 1);
                    while (iC.valid()) {
                        double sqdAC = iC.doubleValue();
                        double simAC = kernelMatrix.getSimilarity((DBIDRef)pA, (DBIDRef)iC);
                        if (sqdAC > 0.0) {
                            double simBC = kernelMatrix.getSimilarity((DBIDRef)iB, (DBIDRef)iC);
                            double numerator = simBC - simAB - simAC + simAA;
                            double div = 1.0 / (sqdAB * sqdAC);
                            s.put(numerator * div, Math.sqrt(div));
                        }
                        iC.advance();
                    }
                }
                iB.advance();
            }
            double abof = s.getCount() > 0.0 ? s.getPopulationVariance() : Double.POSITIVE_INFINITY;
            minmaxabod.put(abof);
            abodvalues.putDouble((DBIDRef)pA, abof);
            pA.advance();
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public static class Par<V extends NumberVector>
    extends ABOD.Par<V> {
        public static final OptionID K_ID = new OptionID("fastabod.k", "Number of nearest neighbors to use for ABOD.");
        protected int k;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)new GreaterEqualConstraint(3))).grab(config, x -> {
                this.k = x;
            });
        }

        @Override
        public FastABOD<V> make() {
            return new FastABOD(this.kernelFunction, this.k);
        }
    }
}

