/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.anglebased;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.DoubleDBIDListMIter;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.QueryBuilder;
import elki.database.query.similarity.SimilarityQuery;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.logging.LoggingConfiguration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.math.DoubleMinMax;
import elki.math.MeanVariance;
import elki.outlier.anglebased.FastABOD;
import elki.result.outlier.InvertedOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.similarity.Similarity;
import elki.similarity.kernel.KernelMatrix;
import elki.utilities.Alias;
import elki.utilities.datastructures.heap.DoubleMinHeap;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import java.util.logging.Level;

@Title(value="LB-ABOD: Lower Bounded Angle-Based Outlier Detection")
@Description(value="Outlier detection using variance analysis on angles, especially for high dimensional data sets.")
@Reference(authors="Hans-Peter Kriegel, Matthias Schubert, Arthur Zimek", title="Angle-Based Outlier Detection in High-dimensional Data", booktitle="Proc. 14th ACM SIGKDD Int. Conf. Knowledge Discovery and Data Mining (KDD'08)", url="https://doi.org/10.1145/1401890.1401946", bibkey="DBLP:conf/kdd/KriegelSZ08")
@Alias(value={"lb-abod"})
public class LBABOD<V extends NumberVector>
extends FastABOD<V> {
    private static final Logging LOG = Logging.getLogger(LBABOD.class);
    protected int l;

    public LBABOD(Similarity<? super V> kernelFunction, int k, int l) {
        super(kernelFunction, k);
        this.l = l;
    }

    @Override
    public OutlierResult run(Relation<V> relation) {
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        DBIDArrayIter pB = ids.iter();
        DBIDArrayIter pC = ids.iter();
        SimilarityQuery sq = new QueryBuilder(relation, this.kernelFunction).similarityQuery();
        KernelMatrix kernelMatrix = new KernelMatrix(sq, relation, (DBIDs)ids);
        WritableDoubleDataStore abodvalues = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)4);
        DoubleMinMax minmaxabod = new DoubleMinMax();
        double max = 0.0;
        WritableDoubleDataStore sqDists = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        KNNHeap nn = DBIDUtil.newHeap((int)this.k);
        ModifiableDoubleDBIDList candidates = DBIDUtil.newDistanceDBIDList((int)relation.size());
        DBIDIter pA = relation.iterDBIDs();
        while (pA.valid()) {
            nn.clear();
            double simAA = kernelMatrix.getSimilarity((DBIDRef)pA, (DBIDRef)pA);
            double sumid = 0.0;
            double sumisqd = 0.0;
            pB.seek(0);
            while (pB.valid()) {
                if (!DBIDUtil.equal((DBIDRef)pB, (DBIDRef)pA)) {
                    double simBB = kernelMatrix.getSimilarity((DBIDRef)pB, (DBIDRef)pB);
                    double simAB = kernelMatrix.getSimilarity((DBIDRef)pA, (DBIDRef)pB);
                    double sqdAB = simAA + simBB - simAB - simAB;
                    sqDists.putDouble((DBIDRef)pB, sqdAB);
                    double isqdAB = 1.0 / sqdAB;
                    sumid += Math.sqrt(isqdAB);
                    sumisqd += isqdAB;
                    nn.insert(sqdAB, (DBIDRef)pB);
                }
                pB.advance();
            }
            double nnsum = 0.0;
            double nnsumsq = 0.0;
            double nnsumisqd = 0.0;
            KNNList nl = nn.toKNNList();
            DoubleDBIDListIter iB = nl.iter();
            DoubleDBIDListIter iC = nl.iter();
            while (iB.valid()) {
                double sqdAB = iB.doubleValue();
                double simAB = kernelMatrix.getSimilarity((DBIDRef)pA, (DBIDRef)iB);
                if (sqdAB > 0.0) {
                    iC.seek(iB.getOffset() + 1);
                    while (iC.valid()) {
                        double sqdAC = iC.doubleValue();
                        double simAC = kernelMatrix.getSimilarity((DBIDRef)pA, (DBIDRef)iC);
                        if (sqdAC > 0.0) {
                            double simBC = kernelMatrix.getSimilarity((DBIDRef)iB, (DBIDRef)iC);
                            double numerator = simBC - simAB - simAC + simAA;
                            double sqweight = 1.0 / (sqdAB * sqdAC);
                            double weight = Math.sqrt(sqweight);
                            double val = numerator * sqweight;
                            nnsum += val * weight;
                            nnsumsq += val * val * weight;
                            nnsumisqd += sqweight;
                        }
                        iC.advance();
                    }
                }
                iB.advance();
            }
            double r2 = sumisqd * sumisqd - 2.0 * nnsumisqd;
            double tmp = (2.0 * nnsum + r2) / (sumid * sumid);
            double lbabof = 2.0 * nnsumsq / (sumid * sumid) - tmp * tmp;
            if (lbabof > max) {
                max = lbabof;
            }
            abodvalues.putDouble((DBIDRef)pA, lbabof);
            candidates.add(lbabof, (DBIDRef)pA);
            pA.advance();
        }
        minmaxabod.put(max);
        candidates.sort();
        int refinements = 0;
        DoubleMinHeap topscores = new DoubleMinHeap(this.l);
        MeanVariance s = new MeanVariance();
        DoubleDBIDListMIter pA2 = candidates.iter();
        while (pA2.valid() && (topscores.size() < this.k || !(pA2.doubleValue() > topscores.peek()))) {
            double abof = this.computeABOF(kernelMatrix, (DBIDRef)pA2, pB, pC, s);
            abodvalues.putDouble((DBIDRef)pA2, abof);
            minmaxabod.put(abof);
            if (topscores.size() < this.k) {
                topscores.add(abof);
            } else if (topscores.peek() > abof) {
                topscores.replaceTopElement(abof);
            }
            ++refinements;
            pA2.advance();
        }
        if (LOG.isStatistics()) {
            LoggingConfiguration.setVerbose((Level)Logging.Level.VERYVERBOSE);
            LOG.statistics((Statistic)new LongStatistic("lb-abod.refinements", (long)refinements));
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Angle-based Outlier Detection", (DBIDs)ids, (DoubleDataStore)abodvalues);
        InvertedOutlierScoreMeta scoreMeta = new InvertedOutlierScoreMeta(minmaxabod.getMin(), minmaxabod.getMax(), 0.0, Double.POSITIVE_INFINITY);
        return new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public static class Par<V extends NumberVector>
    extends FastABOD.Par<V> {
        public static final OptionID L_ID = new OptionID("abod.l", "Number of top outliers to compute.");
        protected int l = 0;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((IntParameter)new IntParameter(L_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.l = x;
            });
        }

        @Override
        public LBABOD<V> make() {
            return new LBABOD(this.kernelFunction, this.k, this.l);
        }
    }
}

