/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.distance;

import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.outlier.distance.AbstractDBOutlier;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;

@Title(value="Distance Based Outlier Score")
@Description(value="Generalization of the original DB-Outlier approach to a ranking method, by turning the fraction parameter into the output value.")
@Reference(prefix="Generalization of a method proposed in", authors="E. M. Knorr, R. T. Ng", title="Algorithms for Mining Distance-Based Outliers in Large Datasets", booktitle="Proc. Int. Conf. on Very Large Databases (VLDB'98)", url="http://www.vldb.org/conf/1998/p392.pdf", bibkey="DBLP:conf/vldb/KnorrN98")
public class DBOutlierScore<O>
extends AbstractDBOutlier<O> {
    private static final Logging LOG = Logging.getLogger(DBOutlierScore.class);

    public DBOutlierScore(Distance<? super O> distance, double d) {
        super(distance, d);
    }

    @Override
    protected DoubleDataStore computeOutlierScores(Relation<O> relation, double d) {
        RangeSearcher rangeQuery = new QueryBuilder(relation, this.distance).rangeByDBID(d);
        int size = relation.size();
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)4);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("DBOutlier scores", relation.size(), LOG) : null;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double n = (double)rangeQuery.getRange((Object)iditer, d).size() / (double)size;
            scores.putDouble((DBIDRef)iditer, 1.0 - n);
            LOG.incrementProcessed((AbstractProgress)prog);
            iditer.advance();
        }
        LOG.ensureCompleted(prog);
        return scores;
    }

    public static class Par<O>
    extends AbstractDBOutlier.Par<O> {
        public DBOutlierScore<O> make() {
            return new DBOutlierScore(this.distance, this.d);
        }
    }
}

