/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.distance;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.Alias;
import elki.utilities.Priority;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="KNN outlier: Efficient Algorithms for Mining Outliers from Large Data Sets")
@Description(value="Outlier Detection based on the distance of an object to its k nearest neighbor.")
@Reference(authors="S. Ramaswamy, R. Rastogi, K. Shim", title="Efficient Algorithms for Mining Outliers from Large Data Sets", booktitle="Proc. Int. Conf. on Management of Data (SIGMOD 2000)", url="https://doi.org/10.1145/342009.335437", bibkey="DBLP:conf/sigmod/RamaswamyRS00")
@Alias(value={"knno"})
@Priority(value=200)
public class KNNOutlier<O>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(KNNOutlier.class);
    protected Distance<? super O> distance;
    protected int kplus;

    public KNNOutlier(Distance<? super O> distance, int k) {
        this.distance = distance;
        this.kplus = k + 1;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        KNNSearcher knnQuery = new QueryBuilder(relation, this.distance).kNNByDBID(this.kplus);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("kNN distance for objects", relation.size(), LOG) : null;
        DoubleMinMax minmax = new DoubleMinMax();
        WritableDoubleDataStore knno_score = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)4);
        DBIDIter it = relation.iterDBIDs();
        while (it.valid()) {
            double dkn = knnQuery.getKNN((Object)it, this.kplus).getKNNDistance();
            knno_score.putDouble((DBIDRef)it, dkn);
            minmax.put(dkn);
            LOG.incrementProcessed((AbstractProgress)prog);
            it.advance();
        }
        LOG.ensureCompleted(prog);
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("kNN Outlier Score", relation.getDBIDs(), (DoubleDataStore)knno_score);
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(meta, (DoubleRelation)scoreres);
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("knno.k", "The k nearest neighbor, excluding the query point (i.e. query point is the 0-nearest-neighbor)");
        protected Distance<? super O> distance;
        protected int k = 0;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
        }

        public KNNOutlier<O> make() {
            return new KNNOutlier<O>(this.distance, this.k);
        }
    }
}

