/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.distance;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.InvertedOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="ODIN: Outlier Detection Using k-Nearest Neighbour Graph")
@Reference(authors="V. Hautam\u00e4ki, I. K\u00e4rkk\u00e4inen, P. Fr\u00e4nti", title="Outlier detection using k-nearest neighbour graph", booktitle="Proc. 17th Int. Conf. Pattern Recognition (ICPR 2004)", url="https://doi.org/10.1109/ICPR.2004.1334558", bibkey="DBLP:conf/icpr/HautamakiKF04")
public class ODIN<O>
implements OutlierAlgorithm {
    protected Distance<? super O> distance;
    protected int kplus;

    public ODIN(Distance<? super O> distance, int k) {
        this.distance = distance;
        this.kplus = k + 1;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        KNNSearcher knnq = new QueryBuilder(relation, this.distance).kNNByDBID(this.kplus);
        DBIDs ids = relation.getDBIDs();
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)30, (double)0.0);
        double inc = 1.0 / (double)(this.kplus - 1);
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            KNNList neighbors = knnq.getKNN((Object)iter, this.kplus);
            DBIDIter nei = neighbors.iter();
            while (nei.valid()) {
                if (!DBIDUtil.equal((DBIDRef)iter, (DBIDRef)nei)) {
                    double value = scores.doubleValue((DBIDRef)nei) + inc;
                    scores.put((DBIDRef)nei, value);
                    minmax.put(value);
                }
                nei.advance();
            }
            iter.advance();
        }
        InvertedOutlierScoreMeta meta = new InvertedOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, inc * (double)(ids.size() - 1), 1.0);
        MaterializedDoubleRelation rel = new MaterializedDoubleRelation("ODIN In-Degree", ids, (DoubleDataStore)scores);
        return new OutlierResult(meta, (DoubleRelation)rel);
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("odin.k", "Number of neighbors to use for kNN graph.");
        protected Distance<? super O> distance;
        protected int k;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
        }

        public ODIN<O> make() {
            return new ODIN<O>(this.distance, this.k);
        }
    }
}

