/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.distance;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.DoubleDBIDListMIter;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.ProbabilisticOutlierScore;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Title(value="SOS: Stochastic Outlier Selection")
@Reference(authors="J. Janssens, F. Husz\u00e1r, E. Postma, J. van den Herik", title="Stochastic Outlier Selection", booktitle="TiCC TR 2012\u2013001", url="https://www.tilburguniversity.edu/upload/b7bac5b2-9b00-402a-9261-7849aa019fbb_sostr.pdf", bibkey="tr/tilburg/JanssensHPv12")
public class SOS<O>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SOS.class);
    protected static final double PERPLEXITY_ERROR = 1.0E-5;
    protected static final int PERPLEXITY_MAXITER = 50;
    protected Distance<? super O> distance;
    protected double perplexity;

    public SOS(Distance<? super O> distance, double h) {
        this.distance = distance;
        this.perplexity = h;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        DistanceQuery dq = new QueryBuilder(relation, this.distance).distanceQuery();
        double logPerp = FastMath.log((double)this.perplexity);
        ModifiableDoubleDBIDList dlist = DBIDUtil.newDistanceDBIDList((int)(relation.size() - 1));
        DoubleDBIDListMIter di = dlist.iter();
        double[] p = new double[relation.size() - 1];
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("SOS scores", relation.size(), LOG) : null;
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)30, (double)1.0);
        DBIDIter it = relation.iterDBIDs();
        while (it.valid()) {
            dlist.clear();
            DBIDIter i2 = relation.iterDBIDs();
            while (i2.valid()) {
                if (!DBIDUtil.equal((DBIDRef)it, (DBIDRef)i2)) {
                    dlist.add(dq.distance((DBIDRef)it, (DBIDRef)i2), (DBIDRef)i2);
                }
                i2.advance();
            }
            dlist.sort();
            SOS.computePi((DBIDRef)it, (DoubleDBIDListIter)di, p, this.perplexity, logPerp);
            double s = SOS.sumOfProbabilities(it, (DBIDArrayIter)di, p);
            if (s > 0.0) {
                SOS.nominateNeighbors(it, (DBIDArrayIter)di, p, 1.0 / s, scores);
            }
            LOG.incrementProcessed((AbstractProgress)prog);
            it.advance();
        }
        LOG.ensureCompleted(prog);
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter it2 = relation.iterDBIDs();
        while (it2.valid()) {
            minmax.put(scores.doubleValue((DBIDRef)it2));
            it2.advance();
        }
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("Stoachastic Outlier Selection", relation.getDBIDs(), (DoubleDataStore)scores);
        ProbabilisticOutlierScore meta = new ProbabilisticOutlierScore(minmax.getMin(), minmax.getMax(), 0.0);
        return new OutlierResult(meta, (DoubleRelation)scoreres);
    }

    public static double sumOfProbabilities(DBIDIter ignore, DBIDArrayIter di, double[] p) {
        double s = 0.0;
        di.seek(0);
        while (di.valid()) {
            if (!DBIDUtil.equal((DBIDRef)ignore, (DBIDRef)di)) {
                double v = p[di.getOffset()];
                if (!(v > 0.0)) break;
                s += v;
            }
            di.advance();
        }
        return s;
    }

    public static void nominateNeighbors(DBIDIter ignore, DBIDArrayIter di, double[] p, double norm, WritableDoubleDataStore scores) {
        di.seek(0);
        while (di.valid()) {
            if (!DBIDUtil.equal((DBIDRef)ignore, (DBIDRef)di)) {
                double v = p[di.getOffset()] * norm;
                if (!(v > 0.0)) break;
                scores.putDouble((DBIDRef)di, scores.doubleValue((DBIDRef)di) * (1.0 - v));
            }
            di.advance();
        }
    }

    public static double computePi(DBIDRef ignore, DoubleDBIDListIter it, double[] p, double perplexity, double logPerp) {
        double beta = SOS.estimateInitialBeta(ignore, it, perplexity);
        double diff = SOS.computeH(ignore, it, p, -beta) - logPerp;
        double betaMin = 0.0;
        double betaMax = Double.POSITIVE_INFINITY;
        for (int tries = 0; tries < 50 && Math.abs(diff) > 1.0E-5; ++tries) {
            if (diff > 0.0) {
                betaMin = beta;
                beta += betaMax == Double.POSITIVE_INFINITY ? beta : (betaMax - beta) * 0.5;
            } else {
                betaMax = beta;
                beta -= (beta - betaMin) * 0.5;
            }
            diff = SOS.computeH(ignore, it, p, -beta) - logPerp;
        }
        return beta;
    }

    @Reference(authors="Erich Schubert, Michael Gertz", title="Intrinsic t-Stochastic Neighbor Embedding for Visualization and Outlier Detection: A Remedy Against the Curse of Dimensionality?", booktitle="Proc. Int. Conf. Similarity Search and Applications, SISAP 2017", url="https://doi.org/10.1007/978-3-319-68474-1_13", bibkey="DBLP:conf/sisap/SchubertG17")
    protected static double estimateInitialBeta(DBIDRef ignore, DoubleDBIDListIter it, double perplexity) {
        double sum = 0.0;
        int size = 0;
        it.seek(0);
        while (it.valid()) {
            if (!DBIDUtil.equal((DBIDRef)ignore, (DBIDRef)it)) {
                sum += it.doubleValue() < Double.POSITIVE_INFINITY ? it.doubleValue() : 0.0;
                ++size;
            }
            it.advance();
        }
        return sum > 0.0 && sum < Double.POSITIVE_INFINITY ? 0.5 / sum * perplexity * ((double)size - 1.0) : 1.0;
    }

    protected static double computeH(DBIDRef ignore, DoubleDBIDListIter it, double[] p, double mbeta) {
        double sumP = 0.0;
        it.seek(0);
        int j = 0;
        while (it.valid()) {
            if (DBIDUtil.equal((DBIDRef)ignore, (DBIDRef)it)) {
                p[j] = 0.0;
            } else {
                p[j] = FastMath.exp((double)(it.doubleValue() * mbeta));
                sumP += p[j];
            }
            ++j;
            it.advance();
        }
        if (!(sumP > 0.0)) {
            return Double.NEGATIVE_INFINITY;
        }
        double s = 1.0 / sumP;
        double sum = 0.0;
        it.seek(0);
        int j2 = 0;
        while (it.valid()) {
            int n = j2++;
            double d = p[n] * s;
            p[n] = d;
            sum += it.doubleValue() * d;
            it.advance();
        }
        return FastMath.log((double)sumP) - mbeta * sum;
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID PERPLEXITY_ID = new OptionID("sos.perplexity", "Perplexity to use.");
        protected Distance<? super O> distance;
        protected double perplexity = 4.5;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((DoubleParameter)new DoubleParameter(PERPLEXITY_ID, 4.5).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.perplexity = x;
            });
        }

        public SOS<O> make() {
            return new SOS<O>(this.distance, this.perplexity);
        }
    }
}

