/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.distance.parallel;

import elki.database.ids.DBIDRef;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.parallel.Executor;
import elki.parallel.processor.AbstractDoubleProcessor;
import elki.parallel.variables.SharedDouble;
import elki.parallel.variables.SharedObject;
import elki.parallel.variables.SharedVariable;

public class KNNWeightProcessor
extends AbstractDoubleProcessor {
    int k;
    SharedObject<? extends KNNList> input;

    public KNNWeightProcessor(int k) {
        this.k = k;
    }

    public void connectKNNInput(SharedObject<? extends KNNList> input) {
        this.input = input;
    }

    public Instance instantiate(Executor executor) {
        return new Instance(this.k, (SharedObject.Instance<? extends KNNList>)((SharedObject.Instance)executor.getInstance(this.input)), (SharedDouble.Instance)executor.getInstance((SharedVariable)this.output));
    }

    private static class Instance
    extends AbstractDoubleProcessor.Instance {
        int k;
        SharedObject.Instance<? extends KNNList> input;

        protected Instance(int k, SharedObject.Instance<? extends KNNList> input, SharedDouble.Instance store) {
            super(store);
            this.k = k;
            this.input = input;
        }

        public void map(DBIDRef id) {
            KNNList list = (KNNList)this.input.get();
            double sum = 0.0;
            DoubleDBIDListIter iter = list.iter();
            for (int i = 0; iter.valid() && i < this.k; ++i) {
                sum += iter.doubleValue();
                iter.advance();
            }
            this.output.set(sum);
        }
    }
}

