/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.intrinsic;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.DoubleDBIDListMIter;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.DoubleMinMax;
import elki.math.statistics.intrinsicdimensionality.AggregatedHillEstimator;
import elki.math.statistics.intrinsicdimensionality.DistanceBasedIntrinsicDimensionalityEstimator;
import elki.outlier.OutlierAlgorithm;
import elki.outlier.distance.SOS;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.ProbabilisticOutlierScore;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.GreaterEqualConstraint;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Title(value="ISOS: Intrinsic Stochastic Outlier Selection")
@Reference(authors="Erich Schubert, Michael Gertz", title="Intrinsic t-Stochastic Neighbor Embedding for Visualization and Outlier Detection: A Remedy Against the Curse of Dimensionality?", booktitle="Proc. Int. Conf. Similarity Search and Applications, SISAP 2017", url="https://doi.org/10.1007/978-3-319-68474-1_13", bibkey="DBLP:conf/sisap/SchubertG17")
public class ISOS<O>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(ISOS.class);
    protected Distance<? super O> distance;
    protected int k;
    protected DistanceBasedIntrinsicDimensionalityEstimator estimator;
    protected double phi = 0.01;

    public ISOS(Distance<? super O> distance, int k, DistanceBasedIntrinsicDimensionalityEstimator estimator) {
        this.distance = distance;
        this.k = k;
        this.estimator = estimator;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        int k1 = this.k + 1;
        double perplexity = (double)this.k / 3.0;
        KNNSearcher knnq = new QueryBuilder(relation, this.distance).kNNByDBID(k1);
        double logPerp = perplexity > 1.0 ? FastMath.log((double)perplexity) : 0.1;
        double[] p = new double[this.k + 10];
        ModifiableDoubleDBIDList dists = DBIDUtil.newDistanceDBIDList((int)(this.k + 10));
        DoubleDBIDListMIter di = dists.iter();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("ISOS scores", relation.size(), LOG) : null;
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)30, (double)1.0);
        DBIDIter it = relation.iterDBIDs();
        while (it.valid()) {
            block5: {
                KNNList knns = knnq.getKNN((Object)it, k1);
                if (p.length < knns.size() + 1) {
                    p = new double[knns.size() + 10];
                }
                DoubleDBIDListIter ki = knns.iter();
                try {
                    double id = this.estimateID((DBIDRef)it, ki, p);
                    ISOS.adjustDistances((DBIDRef)it, ki, knns.getKNNDistance(), id, dists);
                    SOS.computePi((DBIDRef)it, (DoubleDBIDListIter)di, p, perplexity, logPerp);
                    double s = SOS.sumOfProbabilities(it, (DBIDArrayIter)di, p);
                    if (s > 0.0) {
                        ISOS.nominateNeighbors(it, (DBIDArrayIter)di, p, 1.0 / s, scores);
                    }
                }
                catch (ArithmeticException e) {
                    SOS.computePi((DBIDRef)it, ki, p, perplexity, logPerp);
                    double s = SOS.sumOfProbabilities(it, (DBIDArrayIter)ki, p);
                    if (!(s > 0.0)) break block5;
                    ISOS.nominateNeighbors(it, (DBIDArrayIter)ki, p, 1.0 / s, scores);
                }
            }
            LOG.incrementProcessed((AbstractProgress)prog);
            it.advance();
        }
        LOG.ensureCompleted(prog);
        DoubleMinMax minmax = ISOS.transformScores(scores, relation.getDBIDs(), logPerp, this.phi);
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("Intrinsic Stoachastic Outlier Selection", relation.getDBIDs(), (DoubleDataStore)scores);
        ProbabilisticOutlierScore meta = new ProbabilisticOutlierScore(minmax.getMin(), minmax.getMax(), 0.0);
        return new OutlierResult(meta, (DoubleRelation)scoreres);
    }

    protected static void adjustDistances(DBIDRef ignore, DoubleDBIDListIter ki, double max, double id, ModifiableDoubleDBIDList dists) {
        dists.clear();
        double scaleexp = id * 0.5;
        double scalelin = 1.0 / max;
        ki.seek(0);
        while (ki.valid()) {
            if (!DBIDUtil.equal((DBIDRef)ignore, (DBIDRef)ki)) {
                dists.add(FastMath.pow((double)(ki.doubleValue() * scalelin), (double)scaleexp), (DBIDRef)ki);
            }
            ki.advance();
        }
    }

    protected double estimateID(DBIDRef ignore, DoubleDBIDListIter it, double[] p) {
        int j = 0;
        it.seek(0);
        while (it.valid()) {
            if (it.doubleValue() != 0.0 && !DBIDUtil.equal((DBIDRef)ignore, (DBIDRef)it)) {
                p[j++] = it.doubleValue();
            }
            it.advance();
        }
        if (j < 2) {
            throw new ArithmeticException("Too little data to estimate ID.");
        }
        return this.estimator.estimate(p, j);
    }

    public static void nominateNeighbors(DBIDIter ignore, DBIDArrayIter di, double[] p, double norm, WritableDoubleDataStore scores) {
        di.seek(0);
        while (di.valid()) {
            if (!DBIDUtil.equal((DBIDRef)ignore, (DBIDRef)di)) {
                double v = p[di.getOffset()] * norm;
                if (!(v > 0.0)) break;
                scores.increment((DBIDRef)di, FastMath.log1p((double)(-v)));
            }
            di.advance();
        }
    }

    public static DoubleMinMax transformScores(WritableDoubleDataStore scores, DBIDs ids, double logPerp, double phi) {
        DoubleMinMax minmax = new DoubleMinMax();
        double adj = (1.0 - phi) / phi;
        DBIDIter it = ids.iter();
        while (it.valid()) {
            double or = FastMath.exp((double)(-scores.doubleValue((DBIDRef)it) * logPerp)) * adj;
            double s = 1.0 / (1.0 + or);
            scores.putDouble((DBIDRef)it, s);
            minmax.put(s);
            it.advance();
        }
        return minmax;
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID KNN_ID = new OptionID("isos.k", "Number of neighbors to use. Should be about 3x the desired perplexity.");
        public static final OptionID ESTIMATOR_ID = new OptionID("isos.estimator", "Estimator for intrinsic dimensionality.");
        protected Distance<? super O> distance;
        protected int k = 15;
        protected DistanceBasedIntrinsicDimensionalityEstimator estimator = AggregatedHillEstimator.STATIC;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(KNN_ID, 100).addConstraint((ParameterConstraint)new GreaterEqualConstraint(5))).grab(config, x -> {
                this.k = x;
            });
            new ObjectParameter(ESTIMATOR_ID, DistanceBasedIntrinsicDimensionalityEstimator.class, AggregatedHillEstimator.class).grab(config, x -> {
                this.estimator = x;
            });
        }

        public ISOS<O> make() {
            return new ISOS<O>(this.distance, this.k, this.estimator);
        }
    }
}

