/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.intrinsic;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.DoubleMinMax;
import elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import elki.math.statistics.intrinsicdimensionality.MOMEstimator;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="LID: Intrinsic Dimensionality Outlier")
@Reference(authors="Michael E. Houle, Erich Schubert, Arthur Zimek", title="On the Correlation Between Local Intrinsic Dimensionality and Outlierness", booktitle="Proc. 11th Int. Conf. Similarity Search and Applications (SISAP'2018)", url="https://doi.org/10.1007/978-3-030-02224-2_14", bibkey="DBLP:conf/sisap/HouleSZ18")
public class LID<O>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LID.class);
    protected Distance<? super O> distance;
    protected int kplus;
    protected IntrinsicDimensionalityEstimator<? super O> estimator;

    public LID(Distance<? super O> distance, int k, IntrinsicDimensionalityEstimator<? super O> estimator) {
        this.distance = distance;
        this.kplus = k + 1;
        this.estimator = estimator;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        QueryBuilder qb = new QueryBuilder(relation, this.distance);
        DistanceQuery distQ = qb.distanceQuery();
        KNNSearcher knnQ = qb.kNNByDBID(this.kplus);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("kNN distance for objects", relation.size(), LOG) : null;
        DoubleMinMax minmax = new DoubleMinMax();
        WritableDoubleDataStore id_score = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)4);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double id = 0.0;
            try {
                id = this.estimator.estimate(knnQ, distQ, (DBIDRef)iditer, this.kplus);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            id_score.putDouble((DBIDRef)iditer, id);
            minmax.put(id);
            LOG.incrementProcessed((AbstractProgress)prog);
            iditer.advance();
        }
        LOG.ensureCompleted(prog);
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("Intrinsic dimensionality", relation.getDBIDs(), (DoubleDataStore)id_score);
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(meta, (DoubleRelation)scoreres);
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("id.k", "Number of nearest neighbors to use for ID estimation (usually 20-100).");
        public static final OptionID ESTIMATOR_ID = new OptionID("id.estimator", "Class to estimate ID from distance distribution.");
        protected Distance<? super O> distance;
        protected int k;
        protected IntrinsicDimensionalityEstimator<? super O> estimator;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            new ObjectParameter(ESTIMATOR_ID, IntrinsicDimensionalityEstimator.class, MOMEstimator.class).grab(config, x -> {
                this.estimator = x;
            });
        }

        public LID<O> make() {
            return new LID<O>(this.distance, this.k, this.estimator);
        }
    }
}

