/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.lof;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.StepProgress;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.QuotientOutlierScoreMeta;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="COF: Connectivity-based Outlier Factor")
@Reference(authors="J. Tang, Z. Chen, A. W. C. Fu, D. W. Cheung", title="Enhancing effectiveness of outlier detections for low density patterns", booktitle="In Advances in Knowledge Discovery and Data Mining", url="https://doi.org/10.1007/3-540-47887-6_53", bibkey="DBLP:conf/pakdd/TangCFC02")
public class COF<O>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(COF.class);
    protected Distance<? super O> distance;
    protected int k;

    public COF(Distance<? super O> distance, int k) {
        this.distance = distance;
        this.k = k + 1;
    }

    public OutlierResult run(Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("COF", 3) : null;
        DistanceQuery dq = new QueryBuilder(relation, this.distance).distanceQuery();
        LOG.beginStep(stepprog, 1, "Materializing COF neighborhoods.");
        KNNSearcher knnq = new QueryBuilder(dq).precomputed().kNNByDBID(this.k);
        DBIDs ids = relation.getDBIDs();
        LOG.beginStep(stepprog, 2, "Computing Average Chaining Distances.");
        WritableDoubleDataStore acds = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        this.computeAverageChainingDistances((KNNSearcher<DBIDRef>)knnq, dq, ids, acds);
        LOG.beginStep(stepprog, 3, "Computing Connectivity-based Outlier Factors.");
        WritableDoubleDataStore cofs = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)30);
        DoubleMinMax cofminmax = new DoubleMinMax();
        this.computeCOFScores((KNNSearcher<DBIDRef>)knnq, ids, (DoubleDataStore)acds, cofs, cofminmax);
        LOG.setCompleted(stepprog);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Connectivity-Based Outlier Factor", ids, (DoubleDataStore)cofs);
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(cofminmax.getMin(), cofminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
    }

    protected void computeAverageChainingDistances(KNNSearcher<DBIDRef> knnq, DistanceQuery<O> dq, DBIDs ids, WritableDoubleDataStore acds) {
        FiniteProgress lrdsProgress = LOG.isVerbose() ? new FiniteProgress("Computing average chaining distances", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            KNNList neighbors = knnq.getKNN((Object)iter, this.k);
            int r = neighbors.size();
            DoubleDBIDListIter it1 = neighbors.iter();
            DoubleDBIDListIter it2 = neighbors.iter();
            double[] mindists = new double[r];
            int i = 0;
            while (it1.valid()) {
                mindists[i] = DBIDUtil.equal((DBIDRef)it1, (DBIDRef)iter) ? Double.NaN : it1.doubleValue();
                it1.advance();
                ++i;
            }
            double acsum = 0.0;
            for (int j = (r < this.k ? r : this.k) - 1; j > 0; --j) {
                double curdist;
                int i2;
                int minpos = -1;
                double mindist = Double.NaN;
                for (i2 = 0; i2 < mindists.length; ++i2) {
                    curdist = mindists[i2];
                    if (curdist != curdist || curdist > mindist) continue;
                    minpos = i2;
                    mindist = curdist;
                }
                acsum += mindist * (double)j;
                mindists[minpos] = Double.NaN;
                it1.seek(minpos);
                it2.seek(0);
                i2 = 0;
                while (it2.valid()) {
                    double newdist;
                    curdist = mindists[i2];
                    if (curdist == curdist && (newdist = dq.distance((DBIDRef)it1, (DBIDRef)it2)) < curdist) {
                        mindists[i2] = newdist;
                    }
                    it2.advance();
                    ++i2;
                }
            }
            acds.putDouble((DBIDRef)iter, acsum / ((double)r * 0.5 * ((double)r - 1.0)));
            LOG.incrementProcessed((AbstractProgress)lrdsProgress);
            iter.advance();
        }
        LOG.ensureCompleted(lrdsProgress);
    }

    private void computeCOFScores(KNNSearcher<DBIDRef> knnq, DBIDs ids, DoubleDataStore acds, WritableDoubleDataStore cofs, DoubleMinMax cofminmax) {
        FiniteProgress progressCOFs = LOG.isVerbose() ? new FiniteProgress("COF for objects", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            KNNList neighbors = knnq.getKNN((Object)iter, this.k);
            double sum = 0.0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal((DBIDRef)neighbor, (DBIDRef)iter)) {
                    sum += acds.doubleValue((DBIDRef)neighbor);
                }
                neighbor.advance();
            }
            double cof = sum > 0.0 ? acds.doubleValue((DBIDRef)iter) * (double)this.k / sum : (acds.doubleValue((DBIDRef)iter) > 0.0 ? Double.POSITIVE_INFINITY : 1.0);
            cofs.putDouble((DBIDRef)iter, cof);
            cofminmax.put(cof);
            LOG.incrementProcessed((AbstractProgress)progressCOFs);
            iter.advance();
        }
        LOG.ensureCompleted(progressCOFs);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("cof.k", "The number of neighbors (not including the query object) to use for computing the COF score.");
        protected int k;
        protected Distance<? super O> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
        }

        public COF<O> make() {
            return new COF<O>(this.distance, this.k);
        }
    }
}

