/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.lof;

import elki.Algorithm;
import elki.data.type.CombinedTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.knn.PreprocessorKNNQuery;
import elki.database.query.rknn.RKNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.StepProgress;
import elki.math.DoubleMinMax;
import elki.math.MathUtil;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.QuotientOutlierScoreMeta;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="FlexibleLOF: Local Outlier Factor with additional options")
@Description(value="Algorithm to compute density-based local outlier factors in a database based on the neighborhood size parameter 'k'")
@Reference(authors="Markus M. Breunig, Hans-Peter Kriegel, Raymond Ng, J\u00f6rg Sander", title="LOF: Identifying Density-Based Local Outliers", booktitle="Proc. 2nd ACM SIGMOD Int. Conf. on Management of Data (SIGMOD'00)", url="https://doi.org/10.1145/342009.335388", bibkey="DBLP:conf/sigmod/BreunigKNS00")
public class FlexibleLOF<O>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(FlexibleLOF.class);
    protected int krefer = 2;
    protected int kreach = 2;
    protected Distance<? super O> referenceDistance;
    protected Distance<? super O> reachabilityDistance;

    public FlexibleLOF(int krefer, int kreach, Distance<? super O> neighborhoodDistance, Distance<? super O> reachabilityDistance) {
        this.krefer = krefer + 1;
        this.kreach = kreach + 1;
        this.referenceDistance = neighborhoodDistance;
        this.reachabilityDistance = reachabilityDistance;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.reachabilityDistance.equals(this.referenceDistance) ? this.reachabilityDistance.getInputTypeRestriction() : new CombinedTypeInformation(new TypeInformation[]{this.reachabilityDistance.getInputTypeRestriction(), this.referenceDistance.getInputTypeRestriction()})});
    }

    public OutlierResult run(Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("LOF", 3) : null;
        DistanceQuery distQ = new QueryBuilder(relation, this.reachabilityDistance).distanceQuery();
        KNNSearcher knnReach = new QueryBuilder(distQ).optimizedOnly().kNNByDBID(this.kreach);
        if (!(knnReach instanceof PreprocessorKNNQuery)) {
            if (stepprog != null) {
                stepprog.beginStep(1, this.referenceDistance.equals(this.reachabilityDistance) ? "Materializing neighborhoods w.r.t. reference neighborhood distance." : "Not materializing neighborhoods w.r.t. reference neighborhood distance, but materializing neighborhoods w.r.t. reachability distance function.", LOG);
            }
            knnReach = new QueryBuilder(relation, this.reachabilityDistance).precomputed().kNNByDBID(this.referenceDistance.equals(this.reachabilityDistance) ? Math.max(this.kreach, this.krefer) : this.kreach);
        }
        KNNSearcher knnRefer = knnReach;
        if (!this.referenceDistance.equals(this.reachabilityDistance)) {
            knnRefer = new QueryBuilder(relation, this.referenceDistance).kNNByDBID(this.krefer);
        }
        return this.doRunInTime(relation.getDBIDs(), (KNNSearcher<DBIDRef>)knnRefer, (KNNSearcher<DBIDRef>)knnReach, stepprog).getResult();
    }

    protected LOFResult<O> doRunInTime(DBIDs ids, KNNSearcher<DBIDRef> kNNRefer, KNNSearcher<DBIDRef> kNNReach, StepProgress stepprog) {
        if (kNNRefer == null) {
            throw new AbortException("No kNN queries supported by database for reference neighborhood distance function.");
        }
        if (kNNReach == null) {
            throw new AbortException("No kNN queries supported by database for reachability distance function.");
        }
        LOG.beginStep(stepprog, 2, "Computing LRDs.");
        WritableDoubleDataStore lrds = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        this.computeLRDs(kNNReach, ids, lrds);
        LOG.beginStep(stepprog, 3, "Computing LOFs.");
        WritableDoubleDataStore lofs = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)4);
        DoubleMinMax lofminmax = new DoubleMinMax();
        this.computeLOFs(kNNRefer, ids, (DoubleDataStore)lrds, lofs, lofminmax);
        LOG.setCompleted(stepprog);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Local Outlier Factor", ids, (DoubleDataStore)lofs);
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(lofminmax.getMin(), lofminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        OutlierResult result = new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
        return new LOFResult(result, kNNRefer, kNNReach, lrds, lofs);
    }

    protected void computeLRDs(KNNSearcher<DBIDRef> knnq, DBIDs ids, WritableDoubleDataStore lrds) {
        FiniteProgress lrdsProgress = LOG.isVerbose() ? new FiniteProgress("LRD", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            KNNList neighbors = knnq.getKNN((Object)iter, this.kreach);
            double sum = 0.0;
            int count = 0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal((DBIDRef)neighbor, (DBIDRef)iter)) {
                    KNNList neighborsNeighbors = knnq.getKNN((Object)neighbor, this.kreach);
                    sum += MathUtil.max((double)neighbor.doubleValue(), (double)neighborsNeighbors.getKNNDistance());
                    ++count;
                }
                neighbor.advance();
            }
            double lrd = sum > 0.0 ? (double)count / sum : Double.POSITIVE_INFINITY;
            lrds.putDouble((DBIDRef)iter, lrd);
            LOG.incrementProcessed((AbstractProgress)lrdsProgress);
            iter.advance();
        }
        LOG.ensureCompleted(lrdsProgress);
    }

    protected void computeLOFs(KNNSearcher<DBIDRef> knnq, DBIDs ids, DoubleDataStore lrds, WritableDoubleDataStore lofs, DoubleMinMax lofminmax) {
        FiniteProgress progressLOFs = LOG.isVerbose() ? new FiniteProgress("LOF_SCORE for objects", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double lof;
            double lrdp = lrds.doubleValue((DBIDRef)iter);
            KNNList neighbors = knnq.getKNN((Object)iter, this.krefer);
            if (!Double.isInfinite(lrdp)) {
                double sum = 0.0;
                int count = 0;
                DoubleDBIDListIter neighbor = neighbors.iter();
                while (neighbor.valid()) {
                    if (!DBIDUtil.equal((DBIDRef)neighbor, (DBIDRef)iter)) {
                        double val = lrds.doubleValue((DBIDRef)neighbor);
                        sum += val;
                        ++count;
                        if (Double.isInfinite(val)) break;
                    }
                    neighbor.advance();
                }
                lof = sum / (lrdp * (double)count);
            } else {
                lof = 1.0;
            }
            lofs.putDouble((DBIDRef)iter, lof);
            lofminmax.put(lof);
            LOG.incrementProcessed((AbstractProgress)progressLOFs);
            iter.advance();
        }
        LOG.ensureCompleted(progressLOFs);
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID REACHABILITY_DISTANCE_FUNCTION_ID = new OptionID("lof.reachdistfunction", "Distance function to determine the reachability distance between database objects.");
        public static final OptionID KREF_ID = new OptionID("lof.krefer", "The number of nearest neighbors of an object to be considered for computing its LOF score.");
        public static final OptionID KREACH_ID = new OptionID("lof.kreach", "The number of nearest neighbors of an object to be considered for computing its LOF score.");
        protected int krefer = 2;
        protected int kreach = 2;
        protected Distance<? super O> distance;
        protected Distance<? super O> reachabilityDistance = null;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(KREF_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.krefer = x;
            });
            this.kreach = this.krefer;
            ((IntParameter)((IntParameter)new IntParameter(KREACH_ID).setOptional(true)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.kreach = x;
            });
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            this.reachabilityDistance = this.distance;
            new ObjectParameter(REACHABILITY_DISTANCE_FUNCTION_ID, Distance.class).setOptional(true).grab(config, x -> {
                this.reachabilityDistance = x;
            });
        }

        public FlexibleLOF<O> make() {
            return new FlexibleLOF<O>(this.kreach, this.krefer, this.distance, this.reachabilityDistance);
        }
    }

    public static class LOFResult<O> {
        private OutlierResult result;
        private final KNNSearcher<DBIDRef> kNNRefer;
        private final KNNSearcher<DBIDRef> kNNReach;
        private RKNNSearcher<DBIDRef> rkNNRefer;
        private RKNNSearcher<DBIDRef> rkNNReach;
        private final WritableDoubleDataStore lrds;
        private final WritableDoubleDataStore lofs;

        public LOFResult(OutlierResult result, KNNSearcher<DBIDRef> kNNRefer, KNNSearcher<DBIDRef> kNNReach, WritableDoubleDataStore lrds, WritableDoubleDataStore lofs) {
            this.result = result;
            this.kNNRefer = kNNRefer;
            this.kNNReach = kNNReach;
            this.lrds = lrds;
            this.lofs = lofs;
        }

        public KNNSearcher<DBIDRef> getKNNRefer() {
            return this.kNNRefer;
        }

        public KNNSearcher<DBIDRef> getKNNReach() {
            return this.kNNReach;
        }

        public WritableDoubleDataStore getLrds() {
            return this.lrds;
        }

        public WritableDoubleDataStore getLofs() {
            return this.lofs;
        }

        public OutlierResult getResult() {
            return this.result;
        }

        public void setRkNNRefer(RKNNSearcher<DBIDRef> rkNNRefer) {
            this.rkNNRefer = rkNNRefer;
        }

        public RKNNSearcher<DBIDRef> getRkNNRefer() {
            return this.rkNNRefer;
        }

        public RKNNSearcher<DBIDRef> getRkNNReach() {
            return this.rkNNReach;
        }

        public void setRkNNReach(RKNNSearcher<DBIDRef> rkNNReach) {
            this.rkNNReach = rkNNReach;
        }
    }
}

