/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.lof;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDBIDs;
import elki.database.ids.SetDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.StepProgress;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.QuotientOutlierScoreMeta;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="INFLO: Influenced Outlierness Factor")
@Description(value="Ranking Outliers Using Symmetric Neigborhood Relationship")
@Reference(authors="W. Jin, A. Tung, J. Han, W. Wang", title="Ranking outliers using symmetric neighborhood relationship", booktitle="Proc. 10th Pacific-Asia conference on Advances in Knowledge Discovery and Data Mining", url="https://doi.org/10.1007/11731139_68", bibkey="DBLP:conf/pakdd/JinTHW06")
public class INFLO<O>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(INFLO.class);
    private Distance<? super O> distance;
    private double m;
    private int kplus;

    public INFLO(Distance<? super O> distance, double m, int k) {
        this.distance = distance;
        this.m = m;
        this.kplus = k + 1;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("INFLO", 3) : null;
        LOG.beginStep(stepprog, 1, "Materializing nearest-neighbor sets.");
        KNNSearcher knnq = new QueryBuilder(relation, this.distance).precomputed().kNNByDBID(this.kplus);
        LOG.beginStep(stepprog, 2, "Materialize reverse NN.");
        HashSetModifiableDBIDs pruned = DBIDUtil.newHashSet();
        WritableDataStore knns = DataStoreUtil.makeStorage((DBIDs)relation.getDBIDs(), (int)3, SetDBIDs.class);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            knns.put((DBIDRef)iditer, (Object)DBIDUtil.ensureSet((DBIDs)knnq.getKNN((Object)iditer, this.kplus)));
            iditer.advance();
        }
        WritableDataStore rnnMinusKNNs = DataStoreUtil.makeStorage((DBIDs)relation.getDBIDs(), (int)3, ModifiableDBIDs.class);
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            rnnMinusKNNs.put((DBIDRef)iditer2, (Object)DBIDUtil.newArray());
            iditer2.advance();
        }
        this.computeNeighborhoods(relation, (DataStore<SetDBIDs>)knns, (ModifiableDBIDs)pruned, (WritableDataStore<ModifiableDBIDs>)rnnMinusKNNs);
        knns.clear();
        LOG.beginStep(stepprog, 3, "Compute INFLO scores.");
        DoubleMinMax inflominmax = new DoubleMinMax();
        WritableDoubleDataStore inflos = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)4);
        this.computeINFLO(relation, (ModifiableDBIDs)pruned, (KNNSearcher<DBIDRef>)knnq, (WritableDataStore<ModifiableDBIDs>)rnnMinusKNNs, inflos, inflominmax);
        LOG.setCompleted(stepprog);
        LOG.statistics((Statistic)new LongStatistic(INFLO.class.getName() + ".pruned", (long)pruned.size()));
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Influence Outlier Score", relation.getDBIDs(), (DoubleDataStore)inflos);
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(inflominmax.getMin(), inflominmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
    }

    private void computeNeighborhoods(Relation<O> relation, DataStore<SetDBIDs> knns, ModifiableDBIDs pruned, WritableDataStore<ModifiableDBIDs> rNNminuskNNs) {
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Finding RkNN", relation.size(), LOG) : null;
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            DBIDs knn = (DBIDs)knns.get((DBIDRef)iter);
            int count = 1;
            DBIDIter niter = knn.iter();
            while (niter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)iter, (DBIDRef)niter)) {
                    if (((SetDBIDs)knns.get((DBIDRef)niter)).contains((DBIDRef)iter)) {
                        ++count;
                    } else {
                        ((ModifiableDBIDs)rNNminuskNNs.get((DBIDRef)niter)).add((DBIDRef)iter);
                    }
                }
                niter.advance();
            }
            if ((double)count >= (double)knn.size() * this.m) {
                pruned.add((DBIDRef)iter);
            }
            LOG.incrementProcessed((AbstractProgress)prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
    }

    protected void computeINFLO(Relation<O> relation, ModifiableDBIDs pruned, KNNSearcher<DBIDRef> knnq, WritableDataStore<ModifiableDBIDs> rNNminuskNNs, WritableDoubleDataStore inflos, DoubleMinMax inflominmax) {
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Computing INFLOs", relation.size(), LOG) : null;
        HashSetModifiableDBIDs set = DBIDUtil.newHashSet();
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            if (pruned.contains((DBIDRef)iter)) {
                inflos.putDouble((DBIDRef)iter, 1.0);
                inflominmax.put(1.0);
                LOG.incrementProcessed((AbstractProgress)prog);
            } else {
                KNNList knn = knnq.getKNN((Object)iter, this.kplus);
                if (knn.getKNNDistance() == 0.0) {
                    inflos.putDouble((DBIDRef)iter, 1.0);
                    inflominmax.put(1.0);
                    LOG.incrementProcessed((AbstractProgress)prog);
                } else {
                    set.clear().addDBIDs((DBIDs)knn);
                    set.addDBIDs((DBIDs)rNNminuskNNs.get((DBIDRef)iter));
                    double sum = 0.0;
                    int c = 0;
                    DBIDMIter niter = set.iter();
                    while (niter.valid()) {
                        if (!DBIDUtil.equal((DBIDRef)iter, (DBIDRef)niter)) {
                            double kdist = knnq.getKNN((Object)niter, this.kplus).getKNNDistance();
                            if (kdist <= 0.0) {
                                sum = Double.POSITIVE_INFINITY;
                                ++c;
                                break;
                            }
                            sum += 1.0 / kdist;
                            ++c;
                        }
                        niter.advance();
                    }
                    double inflo = (sum *= knn.getKNNDistance()) == 0.0 ? 1.0 : sum / (double)c;
                    inflos.putDouble((DBIDRef)iter, inflo);
                    inflominmax.put(inflo);
                    LOG.incrementProcessed((AbstractProgress)prog);
                }
            }
            iter.advance();
        }
        LOG.ensureCompleted(prog);
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID M_ID = new OptionID("inflo.m", "The pruning threshold");
        public static final OptionID K_ID = new OptionID("inflo.k", "The number of nearest neighbors of an object to be considered for computing its INFLO score.");
        protected Distance<? super O> distance;
        protected double m = 1.0;
        protected int k = 0;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((DoubleParameter)new DoubleParameter(M_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.m = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
        }

        public INFLO<O> make() {
            return new INFLO<O>(this.distance, this.m, this.k);
        }
    }
}

