/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.lof;

import elki.Algorithm;
import elki.data.NumberVector;
import elki.data.type.CombinedTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.StepProgress;
import elki.math.DoubleMinMax;
import elki.math.MathUtil;
import elki.math.statistics.kernelfunctions.GaussianKernelDensityFunction;
import elki.math.statistics.kernelfunctions.KernelDensityFunction;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="LDF: Outlier Detection with Kernel Density Functions")
@Reference(authors="L. J. Latecki, A. Lazarevic, D. Pokrajac", title="Outlier Detection with Kernel Density Functions", booktitle="Machine Learning and Data Mining in Pattern Recognition", url="https://doi.org/10.1007/978-3-540-73499-4_6", bibkey="DBLP:conf/mldm/LateckiLP07")
public class LDF<O extends NumberVector>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LDF.class);
    protected Distance<? super O> distance;
    protected int kplus;
    protected double h = 1.0;
    protected double c = 0.1;
    protected KernelDensityFunction kernel;

    public LDF(int k, Distance<? super O> distance, KernelDensityFunction kernel, double h, double c) {
        this.distance = distance;
        this.kplus = k + 1;
        this.kernel = kernel;
        this.h = h;
        this.c = c;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{new CombinedTypeInformation(new TypeInformation[]{this.distance.getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD})});
    }

    public OutlierResult run(Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("LDF", 3) : null;
        int dim = RelationUtil.dimensionality(relation);
        DBIDs ids = relation.getDBIDs();
        LOG.beginStep(stepprog, 1, "Materializing neighborhoods w.r.t. distance function.");
        KNNSearcher knnq = new QueryBuilder(relation, this.distance).precomputed().kNNByDBID(this.kplus);
        LOG.beginStep(stepprog, 2, "Computing LDEs.");
        WritableDoubleDataStore ldes = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        FiniteProgress densProgress = LOG.isVerbose() ? new FiniteProgress("Densities", ids.size(), LOG) : null;
        DBIDIter it = ids.iter();
        while (it.valid()) {
            KNNList neighbors = knnq.getKNN((Object)it, this.kplus);
            double sum = 0.0;
            int count = 0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal((DBIDRef)neighbor, (DBIDRef)it)) {
                    double nkdist = knnq.getKNN((Object)neighbor, this.kplus).getKNNDistance();
                    if (!(nkdist > 0.0) || nkdist == Double.POSITIVE_INFINITY) {
                        sum = Double.POSITIVE_INFINITY;
                        ++count;
                        break;
                    }
                    double v = MathUtil.max((double)nkdist, (double)neighbor.doubleValue()) / (this.h * nkdist);
                    sum += this.kernel.density(v) / MathUtil.powi((double)(this.h * nkdist), (int)dim);
                    ++count;
                }
                neighbor.advance();
            }
            ldes.putDouble((DBIDRef)it, sum / (double)count);
            LOG.incrementProcessed((AbstractProgress)densProgress);
            it.advance();
        }
        LOG.ensureCompleted(densProgress);
        LOG.beginStep(stepprog, 3, "Computing LDFs.");
        WritableDoubleDataStore ldfs = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)4);
        DoubleMinMax lofminmax = new DoubleMinMax();
        FiniteProgress progressLOFs = LOG.isVerbose() ? new FiniteProgress("Local Density Factors", ids.size(), LOG) : null;
        DBIDIter it2 = ids.iter();
        while (it2.valid()) {
            double lrdp = ldes.doubleValue((DBIDRef)it2);
            KNNList neighbors = knnq.getKNN((Object)it2, this.kplus);
            double sum = 0.0;
            int count = 0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal((DBIDRef)neighbor, (DBIDRef)it2)) {
                    sum += ldes.doubleValue((DBIDRef)neighbor);
                    ++count;
                }
                neighbor.advance();
            }
            double div = lrdp + this.c * (sum /= (double)count);
            double ldf = div == Double.POSITIVE_INFINITY ? (sum < Double.POSITIVE_INFINITY ? 0.0 : 1.0) : (div > 0.0 ? sum / div : 0.0);
            ldfs.putDouble((DBIDRef)it2, ldf);
            lofminmax.put(ldf);
            LOG.incrementProcessed((AbstractProgress)progressLOFs);
            it2.advance();
        }
        LOG.ensureCompleted(progressLOFs);
        LOG.setCompleted(stepprog);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Local Density Factor", ids, (DoubleDataStore)ldfs);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(lofminmax.getMin(), lofminmax.getMax(), 0.0, 1.0 / this.c, 1.0 / (1.0 + this.c));
        OutlierResult result = new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
        return result;
    }

    public static class Par<O extends NumberVector>
    implements Parameterizer {
        public static final OptionID KERNEL_ID = new OptionID("ldf.kernel", "Kernel to use for LDF.");
        public static final OptionID K_ID = new OptionID("ldf.k", "Number of neighbors to use for LDF.");
        public static final OptionID H_ID = new OptionID("ldf.h", "Kernel bandwidth multiplier for LDF.");
        public static final OptionID C_ID = new OptionID("ldf.c", "Score scaling parameter for LDF.");
        protected Distance<? super O> distance;
        protected int k = 2;
        protected KernelDensityFunction kernel;
        protected double h = 1.0;
        protected double c = 0.1;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            new ObjectParameter(KERNEL_ID, KernelDensityFunction.class, GaussianKernelDensityFunction.class).grab(config, x -> {
                this.kernel = x;
            });
            new DoubleParameter(H_ID).grab(config, x -> {
                this.h = x;
            });
            new DoubleParameter(C_ID, 0.1).grab(config, x -> {
                this.c = x;
            });
        }

        public LDF<O> make() {
            return new LDF<O>(this.k, this.distance, this.kernel, this.h, this.c);
        }
    }
}

