/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.lof;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.DoubleMinMax;
import elki.math.Mean;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.QuotientOutlierScoreMeta;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="LDOF: Local Distance-Based Outlier Factor")
@Description(value="Local outlier detection appraoch suitable for scattered data by averaging the kNN distance over all k nearest neighbors")
@Reference(authors="K. Zhang, M. Hutter, H. Jin", title="A New Local Distance-Based Outlier Detection Approach for Scattered Real-World Data", booktitle="Proc. 13th Pacific-Asia Conf. Adv. Knowledge Discovery and Data Mining (PAKDD 2009)", url="https://doi.org/10.1007/978-3-642-01307-2_84", bibkey="DBLP:conf/pakdd/ZhangHJ09")
public class LDOF<O>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LDOF.class);
    private static final double LDOF_BASELINE = 0.5;
    protected Distance<? super O> distance;
    protected int kplus;

    public LDOF(Distance<? super O> distance, int k) {
        this.distance = distance;
        this.kplus = k + 1;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        QueryBuilder qb = new QueryBuilder(relation, this.distance);
        KNNSearcher knnQuery = qb.kNNByDBID(this.kplus);
        DistanceQuery distFunc = qb.distanceQuery();
        DoubleMinMax ldofminmax = new DoubleMinMax();
        WritableDoubleDataStore ldofs = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)3);
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)"Computing LDOFs");
        }
        FiniteProgress progressLDOFs = LOG.isVerbose() ? new FiniteProgress("LDOF for objects", relation.size(), LOG) : null;
        Mean dxp = new Mean();
        Mean Dxp = new Mean();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList neighbors = knnQuery.getKNN((Object)iditer, this.kplus);
            dxp.reset();
            Dxp.reset();
            DoubleDBIDListIter neighbor1 = neighbors.iter();
            DoubleDBIDListIter neighbor2 = neighbors.iter();
            while (neighbor1.valid()) {
                if (!DBIDUtil.equal((DBIDRef)neighbor1, (DBIDRef)iditer)) {
                    dxp.put(neighbor1.doubleValue());
                    neighbor2.seek(neighbor1.getOffset() + 1);
                    while (neighbor2.valid()) {
                        if (!DBIDUtil.equal((DBIDRef)neighbor2, (DBIDRef)iditer)) {
                            Dxp.put(distFunc.distance((DBIDRef)neighbor1, (DBIDRef)neighbor2));
                        }
                        neighbor2.advance();
                    }
                }
                neighbor1.advance();
            }
            double ldof = dxp.getMean() / Dxp.getMean();
            if (Double.isNaN(ldof) || Double.isInfinite(ldof)) {
                ldof = 1.0;
            }
            ldofs.putDouble((DBIDRef)iditer, ldof);
            ldofminmax.put(ldof);
            LOG.incrementProcessed((AbstractProgress)progressLDOFs);
            iditer.advance();
        }
        LOG.ensureCompleted(progressLDOFs);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("LDOF Outlier Score", relation.getDBIDs(), (DoubleDataStore)ldofs);
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(ldofminmax.getMin(), ldofminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.5);
        return new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("ldof.k", "The number of nearest neighbors of an object to be considered for computing its LDOF_SCORE.");
        protected Distance<? super O> distance;
        protected int k;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
        }

        public LDOF<O> make() {
            return new LDOF<O>(this.distance, this.k);
        }
    }
}

