/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.lof;

import elki.data.type.CombinedTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.StepProgress;
import elki.math.DoubleMinMax;
import elki.math.MathUtil;
import elki.math.statistics.distribution.NormalDistribution;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.ProbabilisticOutlierScore;
import elki.utilities.Priority;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="LoOP: Local Outlier Probabilities")
@Description(value="Variant of the LOF algorithm normalized using statistical values.")
@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="LoOP: Local Outlier Probabilities", booktitle="Proc. 18th Int. Conf. Information and Knowledge Management (CIKM 2009)", url="https://doi.org/10.1145/1645953.1646195", bibkey="DBLP:conf/cikm/KriegelKSZ09")
@Priority(value=200)
public class LoOP<O>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LoOP.class);
    int kreach;
    int kcomp;
    double lambda;
    protected Distance<? super O> reachabilityDistance;
    protected Distance<? super O> comparisonDistance;

    public LoOP(int kreach, int kcomp, Distance<? super O> reachabilityDistance, Distance<? super O> comparisonDistance, double lambda) {
        this.kreach = kreach;
        this.kcomp = kcomp;
        this.reachabilityDistance = reachabilityDistance;
        this.comparisonDistance = comparisonDistance;
        this.lambda = lambda;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.reachabilityDistance.equals(this.comparisonDistance) ? this.reachabilityDistance.getInputTypeRestriction() : new CombinedTypeInformation(new TypeInformation[]{this.reachabilityDistance.getInputTypeRestriction(), this.comparisonDistance.getInputTypeRestriction()})});
    }

    public OutlierResult run(Relation<O> relation) {
        KNNSearcher knnReach;
        KNNSearcher knnComp;
        StepProgress stepprog;
        StepProgress stepProgress = stepprog = LOG.isVerbose() ? new StepProgress(5) : null;
        if (this.comparisonDistance == this.reachabilityDistance || this.comparisonDistance.equals(this.reachabilityDistance)) {
            LOG.beginStep(stepprog, 1, "Materializing neighborhoods with respect to reference neighborhood distance function.");
            knnReach = knnComp = new QueryBuilder(relation, this.comparisonDistance).precomputed().kNNByDBID(MathUtil.max((int)this.kcomp, (int)this.kreach) + 1);
        } else {
            LOG.beginStep(stepprog, 1, "Not materializing distance functions, since we request each DBID once only.");
            knnComp = new QueryBuilder(relation, this.comparisonDistance).kNNByDBID(this.kreach + 1);
            knnReach = new QueryBuilder(relation, this.reachabilityDistance).kNNByDBID(this.kcomp + 1);
        }
        if (knnComp == null) {
            throw new AbortException("No kNN queries supported by database for comparison distance function.");
        }
        if (knnReach == null) {
            throw new AbortException("No kNN queries supported by database for density estimation distance function.");
        }
        WritableDoubleDataStore pdists = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)30);
        LOG.beginStep(stepprog, 3, "Computing pdists");
        this.computePDists(relation, (KNNSearcher<DBIDRef>)knnReach, pdists);
        WritableDoubleDataStore plofs = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)3);
        LOG.beginStep(stepprog, 4, "Computing PLOF");
        double nplof = this.computePLOFs(relation, (KNNSearcher<DBIDRef>)knnComp, pdists, plofs);
        DoubleMinMax mm = new DoubleMinMax();
        LOG.beginStep(stepprog, 5, "Computing LoOP scores");
        FiniteProgress progressLOOPs = LOG.isVerbose() ? new FiniteProgress("LoOP for objects", relation.size(), LOG) : null;
        double norm = 1.0 / (nplof * MathUtil.SQRT2);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double loop = NormalDistribution.erf((double)((plofs.doubleValue((DBIDRef)iditer) - 1.0) * norm));
            plofs.putDouble((DBIDRef)iditer, loop);
            mm.put(loop);
            LOG.incrementProcessed((AbstractProgress)progressLOOPs);
            iditer.advance();
        }
        LOG.ensureCompleted(progressLOOPs);
        LOG.setCompleted(stepprog);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Local Outlier Probabilities", relation.getDBIDs(), (DoubleDataStore)plofs);
        ProbabilisticOutlierScore scoreMeta = new ProbabilisticOutlierScore(mm.getMin(), mm.getMax(), 0.0);
        return new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
    }

    protected void computePDists(Relation<O> relation, KNNSearcher<DBIDRef> knn, WritableDoubleDataStore pdists) {
        FiniteProgress prdsProgress = LOG.isVerbose() ? new FiniteProgress("pdists", relation.size(), LOG) : null;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList neighbors = knn.getKNN((Object)iditer, this.kreach + 1);
            int ks = 0;
            double ssum = 0.0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid() && ks < this.kreach) {
                if (!DBIDUtil.equal((DBIDRef)neighbor, (DBIDRef)iditer)) {
                    double d = neighbor.doubleValue();
                    ssum += d * d;
                    ++ks;
                }
                neighbor.advance();
            }
            double pdist = ks > 0 ? Math.sqrt(ssum / (double)ks) : 0.0;
            pdists.putDouble((DBIDRef)iditer, pdist);
            LOG.incrementProcessed((AbstractProgress)prdsProgress);
            iditer.advance();
        }
        LOG.ensureCompleted(prdsProgress);
    }

    protected double computePLOFs(Relation<O> relation, KNNSearcher<DBIDRef> knn, WritableDoubleDataStore pdists, WritableDoubleDataStore plofs) {
        FiniteProgress progressPLOFs = LOG.isVerbose() ? new FiniteProgress("PLOFs for objects", relation.size(), LOG) : null;
        double nplof = 0.0;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList neighbors = knn.getKNN((Object)iditer, this.kcomp + 1);
            int ks = 0;
            double sum = 0.0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid() && ks < this.kcomp) {
                if (!DBIDUtil.equal((DBIDRef)neighbor, (DBIDRef)iditer)) {
                    sum += pdists.doubleValue((DBIDRef)neighbor);
                    ++ks;
                }
                neighbor.advance();
            }
            double plof = MathUtil.max((double)(pdists.doubleValue((DBIDRef)iditer) * (double)ks / sum), (double)1.0);
            if (Double.isNaN(plof) || Double.isInfinite(plof)) {
                plof = 1.0;
            }
            plofs.putDouble((DBIDRef)iditer, plof);
            nplof += (plof - 1.0) * (plof - 1.0);
            LOG.incrementProcessed((AbstractProgress)progressPLOFs);
            iditer.advance();
        }
        LOG.ensureCompleted(progressPLOFs);
        nplof = this.lambda * Math.sqrt(nplof / (double)relation.size());
        if (LOG.isDebuggingFine()) {
            LOG.debugFine((CharSequence)("nplof normalization factor is " + nplof));
        }
        return nplof > 0.0 ? nplof : 1.0;
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID REACHABILITY_DISTANCE_FUNCTION_ID = new OptionID("loop.referencedistfunction", "Distance function to determine the density of an object.");
        public static final OptionID COMPARISON_DISTANCE_FUNCTION_ID = new OptionID("loop.comparedistfunction", "Distance function to determine the reference set of an object.");
        public static final OptionID KREACH_ID = new OptionID("loop.kref", "The number of nearest neighbors of an object to be used for the PRD value.");
        public static final OptionID KCOMP_ID = new OptionID("loop.kcomp", "The number of nearest neighbors of an object to be considered for computing its LOOP_SCORE.");
        public static final OptionID LAMBDA_ID = new OptionID("loop.lambda", "The number of standard deviations to consider for density computation.");
        int kreach = 0;
        int kcomp = 0;
        double lambda = 2.0;
        protected Distance<O> reachabilityDistance = null;
        protected Distance<O> comparisonDistance = null;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(KCOMP_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.kcomp = x;
            });
            new ObjectParameter(COMPARISON_DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.comparisonDistance = x;
            });
            this.kreach = this.kcomp;
            ((IntParameter)((IntParameter)new IntParameter(KREACH_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).setOptional(true)).grab(config, x -> {
                this.kreach = x;
            });
            new ObjectParameter(REACHABILITY_DISTANCE_FUNCTION_ID, Distance.class).setOptional(true).grab(config, x -> {
                this.reachabilityDistance = x;
            });
            ((DoubleParameter)new DoubleParameter(LAMBDA_ID, 2.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.lambda = x;
            });
        }

        public LoOP<O> make() {
            Distance<O> realreach = this.reachabilityDistance != null ? this.reachabilityDistance : this.comparisonDistance;
            return new LoOP<O>(this.kreach, this.kcomp, realreach, this.comparisonDistance, this.lambda);
        }
    }
}

