/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.lof;

import elki.Algorithm;
import elki.data.NumberVector;
import elki.data.type.CombinedTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.StepProgress;
import elki.math.DoubleMinMax;
import elki.math.MathUtil;
import elki.math.statistics.kernelfunctions.EpanechnikovKernelDensityFunction;
import elki.math.statistics.kernelfunctions.KernelDensityFunction;
import elki.outlier.OutlierAlgorithm;
import elki.outlier.lof.LOF;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.QuotientOutlierScoreMeta;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public class SimpleKernelDensityLOF<O extends NumberVector>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SimpleKernelDensityLOF.class);
    protected Distance<? super O> distance;
    protected int kplus;
    protected KernelDensityFunction kernel;

    public SimpleKernelDensityLOF(int k, Distance<? super O> distance, KernelDensityFunction kernel) {
        this.distance = distance;
        this.kplus = k + 1;
        this.kernel = kernel;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{new CombinedTypeInformation(new TypeInformation[]{this.distance.getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD})});
    }

    public OutlierResult run(Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("KernelDensityLOF", 3) : null;
        int dim = RelationUtil.dimensionality(relation);
        DBIDs ids = relation.getDBIDs();
        LOG.beginStep(stepprog, 1, "Materializing neighborhoods w.r.t. distance function.");
        KNNSearcher knnq = new QueryBuilder(relation, this.distance).precomputed().kNNByDBID(this.kplus);
        LOG.beginStep(stepprog, 2, "Computing densities.");
        WritableDoubleDataStore dens = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        FiniteProgress densProgress = LOG.isVerbose() ? new FiniteProgress("Densities", ids.size(), LOG) : null;
        DBIDIter it = ids.iter();
        while (it.valid()) {
            KNNList neighbors = knnq.getKNN((Object)it, this.kplus);
            int count = 0;
            double sum = 0.0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal((DBIDRef)neighbor, (DBIDRef)it)) {
                    double max = knnq.getKNN((Object)neighbor, this.kplus).getKNNDistance();
                    if (max == 0.0) {
                        sum = Double.POSITIVE_INFINITY;
                        break;
                    }
                    double v = neighbor.doubleValue() / max;
                    sum += this.kernel.density(v) / MathUtil.powi((double)max, (int)dim);
                    ++count;
                }
                neighbor.advance();
            }
            double density = count > 0 ? sum / (double)count : 0.0;
            dens.putDouble((DBIDRef)it, density);
            LOG.incrementProcessed((AbstractProgress)densProgress);
            it.advance();
        }
        LOG.ensureCompleted(densProgress);
        LOG.beginStep(stepprog, 3, "Computing KLOFs.");
        WritableDoubleDataStore lofs = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)4);
        DoubleMinMax lofminmax = new DoubleMinMax();
        FiniteProgress progressLOFs = LOG.isVerbose() ? new FiniteProgress("KLOF_SCORE for objects", ids.size(), LOG) : null;
        DBIDIter it2 = ids.iter();
        while (it2.valid()) {
            double lof;
            double lrdp = dens.doubleValue((DBIDRef)it2);
            if (lrdp > 0.0) {
                KNNList neighbors = knnq.getKNN((Object)it2, this.kplus);
                double sum = 0.0;
                int count = 0;
                DoubleDBIDListIter neighbor = neighbors.iter();
                while (neighbor.valid()) {
                    if (!DBIDUtil.equal((DBIDRef)neighbor, (DBIDRef)it2)) {
                        sum += dens.doubleValue((DBIDRef)neighbor);
                        ++count;
                    }
                    neighbor.advance();
                }
                lof = lrdp == Double.POSITIVE_INFINITY ? (sum == Double.POSITIVE_INFINITY ? 1.0 : 0.0) : sum / ((double)count * lrdp);
            } else {
                lof = 1.0;
            }
            lofs.putDouble((DBIDRef)it2, lof);
            lofminmax.put(lof);
            LOG.incrementProcessed((AbstractProgress)progressLOFs);
            it2.advance();
        }
        LOG.ensureCompleted(progressLOFs);
        LOG.setCompleted(stepprog);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Kernel Density Local Outlier Factor", ids, (DoubleDataStore)lofs);
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(lofminmax.getMin(), lofminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        OutlierResult result = new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
        return result;
    }

    public static class Par<O extends NumberVector>
    implements Parameterizer {
        public static final OptionID KERNEL_ID = new OptionID("kernellof.kernel", "Kernel to use for kernel density LOF.");
        protected Distance<? super O> distance;
        protected int k;
        protected KernelDensityFunction kernel;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(LOF.Par.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            new ObjectParameter(KERNEL_ID, KernelDensityFunction.class, EpanechnikovKernelDensityFunction.class).grab(config, x -> {
                this.kernel = x;
            });
        }

        public SimpleKernelDensityLOF<O> make() {
            return new SimpleKernelDensityLOF<O>(this.k, this.distance, this.kernel);
        }
    }
}

