/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.lof;

import elki.Algorithm;
import elki.data.spatial.SpatialComparable;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.StepProgress;
import elki.math.DoubleMinMax;
import elki.math.MathUtil;
import elki.math.statistics.distribution.GammaDistribution;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Reference(authors="T. Hu, S. Y. Sung", title="Detecting pattern-based outliers", booktitle="Pattern Recognition Letters 24(16)", url="https://doi.org/10.1016/S0167-8655(03)00165-X", bibkey="DBLP:journals/prl/HuS03")
public class VarianceOfVolume<O extends SpatialComparable>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(VarianceOfVolume.class);
    protected Distance<? super O> distance;
    protected int kplus;

    public VarianceOfVolume(int k, Distance<? super O> distance) {
        this.distance = distance;
        this.kplus = k + 1;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("VOV", 3) : null;
        DBIDs ids = relation.getDBIDs();
        int dim = RelationUtil.dimensionality(relation);
        LOG.beginStep(stepprog, 1, "Materializing nearest-neighbor sets.");
        KNNSearcher knnq = new QueryBuilder(relation, this.distance).precomputed().kNNByDBID(this.kplus);
        LOG.beginStep(stepprog, 2, "Computing Volumes.");
        WritableDoubleDataStore vols = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        this.computeVolumes((KNNSearcher<DBIDRef>)knnq, dim, ids, vols);
        LOG.beginStep(stepprog, 3, "Computing Variance of Volumes (VOV).");
        WritableDoubleDataStore vovs = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)30);
        DoubleMinMax vovminmax = new DoubleMinMax();
        this.computeVOVs((KNNSearcher<DBIDRef>)knnq, ids, (DoubleDataStore)vols, vovs, vovminmax);
        LOG.setCompleted(stepprog);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Variance of Volume", ids, (DoubleDataStore)vovs);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(vovminmax.getMin(), vovminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
    }

    private void computeVolumes(KNNSearcher<DBIDRef> knnq, int dim, DBIDs ids, WritableDoubleDataStore vols) {
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Volume", ids.size(), LOG) : null;
        double scaleconst = MathUtil.SQRTPI * FastMath.pow((double)GammaDistribution.gamma((double)(1.0 + (double)dim * 0.5)), (double)(-1.0 / (double)dim));
        boolean warned = false;
        double sum = 0.0;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double vol;
            double dk = knnq.getKNN((Object)iter, this.kplus).getKNNDistance();
            double d = vol = dk > 0.0 ? MathUtil.powi((double)(dk * scaleconst), (int)dim) : 0.0;
            if (vol == Double.POSITIVE_INFINITY && !warned) {
                LOG.warning((CharSequence)"Variance of Volumes has hit double precision limits, results are not reliable.");
                warned = true;
            }
            vols.putDouble((DBIDRef)iter, vol);
            sum += vol;
            LOG.incrementProcessed((AbstractProgress)prog);
            iter.advance();
        }
        double scaling = (double)ids.size() / sum;
        DBIDIter iter2 = ids.iter();
        while (iter2.valid()) {
            vols.putDouble((DBIDRef)iter2, vols.doubleValue((DBIDRef)iter2) * scaling);
            iter2.advance();
        }
        LOG.ensureCompleted(prog);
    }

    private void computeVOVs(KNNSearcher<DBIDRef> knnq, DBIDs ids, DoubleDataStore vols, WritableDoubleDataStore vovs, DoubleMinMax vovminmax) {
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Variance of Volume", ids.size(), LOG) : null;
        boolean warned = false;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            KNNList knns = knnq.getKNN((Object)iter, this.kplus);
            DoubleDBIDListIter it = knns.iter();
            double vbar = 0.0;
            while (it.valid()) {
                vbar += vols.doubleValue((DBIDRef)it);
                it.advance();
            }
            vbar /= (double)knns.size();
            double vov = 0.0;
            it.seek(0);
            while (it.valid()) {
                double v = vols.doubleValue((DBIDRef)it) - vbar;
                vov += v * v;
                it.advance();
            }
            if (!(vov < Double.POSITIVE_INFINITY) && !warned) {
                LOG.warning((CharSequence)"Variance of Volumes has hit double precision limits, results are not reliable.");
                warned = true;
            }
            vov = vov < Double.POSITIVE_INFINITY ? vov / (double)(knns.size() - 1) : Double.POSITIVE_INFINITY;
            vovs.putDouble((DBIDRef)iter, vov);
            vovminmax.put(vov);
            LOG.incrementProcessed((AbstractProgress)prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
    }

    public static class Par<O extends SpatialComparable>
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("vov.k", "The number of nearest neighbors (not including the query point) of an object to be considered for computing its VOV score.");
        protected Distance<? super O> distance;
        protected int k = 2;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
        }

        public VarianceOfVolume<O> make() {
            return new VarianceOfVolume<O>(this.k, this.distance);
        }
    }
}

