/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.lof.parallel;

import elki.database.datastore.DataStore;
import elki.database.datastore.DoubleDataStore;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.parallel.Executor;
import elki.parallel.processor.AbstractDoubleProcessor;
import elki.parallel.variables.SharedDouble;
import elki.parallel.variables.SharedVariable;

public class LOFProcessor
extends AbstractDoubleProcessor {
    private DataStore<? extends KNNList> knns;
    private DoubleDataStore lrds;
    private boolean noself;

    public LOFProcessor(DataStore<? extends KNNList> knns, DoubleDataStore lrds, boolean noself) {
        this.knns = knns;
        this.lrds = lrds;
        this.noself = noself;
    }

    public Instance instantiate(Executor master) {
        return new Instance((SharedDouble.Instance)master.getInstance((SharedVariable)this.output));
    }

    private class Instance
    extends AbstractDoubleProcessor.Instance {
        protected Instance(SharedDouble.Instance output) {
            super(output);
        }

        public void map(DBIDRef id) {
            double lrdp = LOFProcessor.this.lrds.doubleValue(id);
            if (Double.isInfinite(lrdp)) {
                this.output.set(1.0);
                return;
            }
            KNNList knn = (KNNList)LOFProcessor.this.knns.get(id);
            double avlrd = 0.0;
            int cnt = 0;
            DoubleDBIDListIter n = knn.iter();
            while (n.valid()) {
                if (!LOFProcessor.this.noself || !DBIDUtil.equal((DBIDRef)n, (DBIDRef)id)) {
                    ++cnt;
                    if (Double.isInfinite(avlrd += LOFProcessor.this.lrds.doubleValue((DBIDRef)n))) break;
                }
                n.advance();
            }
            avlrd = cnt > 0 ? avlrd / (double)cnt : 0.0;
            this.output.set(avlrd / lrdp);
        }
    }
}

