/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.lof.parallel;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.outlier.lof.LOF;
import elki.outlier.lof.parallel.LOFProcessor;
import elki.outlier.lof.parallel.SimplifiedLRDProcessor;
import elki.parallel.ParallelExecutor;
import elki.parallel.processor.DoubleMinMaxProcessor;
import elki.parallel.processor.KNNProcessor;
import elki.parallel.processor.Processor;
import elki.parallel.processor.WriteDataStoreProcessor;
import elki.parallel.processor.WriteDoubleDataStoreProcessor;
import elki.parallel.variables.SharedDouble;
import elki.parallel.variables.SharedObject;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Local Outlier Detection Reconsidered: a Generalized View on Locality with Applications to Spatial, Video, and Network Outlier Detection", booktitle="Data Mining and Knowledge Discovery 28(1)", url="https://doi.org/10.1007/s10618-012-0300-z", bibkey="DBLP:journals/datamine/SchubertZK14")
public class ParallelSimplifiedLOF<O>
implements OutlierAlgorithm {
    protected Distance<? super O> distance;
    protected int kplus;

    public ParallelSimplifiedLOF(Distance<? super O> distance, int k) {
        this.distance = distance;
        this.kplus = k + 1;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public OutlierResult run(Relation<O> relation) {
        DBIDs ids = relation.getDBIDs();
        QueryBuilder qb = new QueryBuilder(relation, this.distance);
        WritableDataStore knns = DataStoreUtil.makeStorage((DBIDs)ids, (int)30, KNNList.class);
        KNNProcessor knnm = new KNNProcessor(this.kplus, () -> qb.kNNByDBID(this.kplus));
        SharedObject knnv = new SharedObject();
        WriteDataStoreProcessor storek = new WriteDataStoreProcessor(knns);
        knnm.connectKNNOutput(knnv);
        storek.connectInput(knnv);
        ParallelExecutor.run((DBIDs)ids, (Processor[])new Processor[]{knnm, storek});
        WritableDoubleDataStore lrds = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)30);
        SimplifiedLRDProcessor lrdm = new SimplifiedLRDProcessor((DataStore<? extends KNNList>)knns);
        SharedDouble lrdv = new SharedDouble();
        WriteDoubleDataStoreProcessor storelrd = new WriteDoubleDataStoreProcessor(lrds);
        lrdm.connectOutput(lrdv);
        storelrd.connectInput(lrdv);
        ParallelExecutor.run((DBIDs)ids, (Processor[])new Processor[]{lrdm, storelrd});
        WritableDoubleDataStore lofs = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)30);
        LOFProcessor lofm = new LOFProcessor((DataStore<? extends KNNList>)knns, (DoubleDataStore)lrds, true);
        SharedDouble lofv = new SharedDouble();
        DoubleMinMaxProcessor mmm = new DoubleMinMaxProcessor();
        WriteDoubleDataStoreProcessor storelof = new WriteDoubleDataStoreProcessor(lofs);
        lofm.connectOutput(lofv);
        mmm.connectInput(lofv);
        storelof.connectInput(lofv);
        ParallelExecutor.run((DBIDs)ids, (Processor[])new Processor[]{lofm, storelof, mmm});
        DoubleMinMax minmax = mmm.getMinMax();
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("Simplified Local Outlier Factor", ids, (DoubleDataStore)lofs);
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(meta, (DoubleRelation)scoreres);
    }

    public static class Par<O>
    implements Parameterizer {
        protected Distance<? super O> distance;
        protected int k;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new IntParameter(LOF.Par.K_ID).grab(config, x -> {
                this.k = x;
            });
        }

        public ParallelSimplifiedLOF<O> make() {
            return new ParallelSimplifiedLOF<O>(this.distance, this.k);
        }
    }
}

