/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.lof.parallel;

import elki.database.datastore.DataStore;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.parallel.Executor;
import elki.parallel.processor.AbstractDoubleProcessor;
import elki.parallel.variables.SharedDouble;
import elki.parallel.variables.SharedVariable;

public class SimplifiedLRDProcessor
extends AbstractDoubleProcessor {
    private DataStore<? extends KNNList> knns;

    public SimplifiedLRDProcessor(DataStore<? extends KNNList> knns) {
        this.knns = knns;
    }

    public Instance instantiate(Executor master) {
        return new Instance((SharedDouble.Instance)master.getInstance((SharedVariable)this.output));
    }

    private class Instance
    extends AbstractDoubleProcessor.Instance {
        public Instance(SharedDouble.Instance output) {
            super(output);
        }

        public void map(DBIDRef id) {
            KNNList knn = (KNNList)SimplifiedLRDProcessor.this.knns.get(id);
            double lrd = 0.0;
            int size = 0;
            DoubleDBIDListIter n = knn.iter();
            while (n.valid()) {
                if (!DBIDUtil.equal((DBIDRef)n, (DBIDRef)id)) {
                    lrd += n.doubleValue();
                    ++size;
                }
                n.advance();
            }
            this.output.set(lrd > 0.0 ? (double)size / lrd : 0.0);
        }
    }
}

