/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.meta;

import elki.Algorithm;
import elki.data.type.CombinedTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.DoubleMinMax;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.ensemble.EnsembleVoting;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectListParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SimpleOutlierEnsemble
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SimpleOutlierEnsemble.class);
    private List<? extends OutlierAlgorithm> algorithms;
    private EnsembleVoting voting;

    public SimpleOutlierEnsemble(List<? extends OutlierAlgorithm> algorithms, EnsembleVoting voting) {
        this.algorithms = algorithms;
        this.voting = voting;
    }

    public TypeInformation[] getInputTypeRestriction() {
        TypeInformation[] trs = new TypeInformation[this.algorithms.size()];
        for (int i = 0; i < trs.length; ++i) {
            trs[i] = this.algorithms.get(i).getInputTypeRestriction()[0];
        }
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{new CombinedTypeInformation(trs)});
    }

    @Override
    public OutlierResult autorun(Database database) throws IllegalStateException {
        int num = this.algorithms.size();
        HashSetModifiableDBIDs ids = DBIDUtil.newHashSet();
        ArrayList<OutlierResult> results = new ArrayList<OutlierResult>(num);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Inner outlier algorithms", num, LOG) : null;
        for (OutlierAlgorithm outlierAlgorithm : this.algorithms) {
            OutlierResult or = outlierAlgorithm.autorun(database);
            results.add(or);
            ids.addDBIDs(or.getScores().getDBIDs());
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        LOG.ensureCompleted(prog);
        WritableDoubleDataStore sumscore = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)4);
        DoubleMinMax minmax = new DoubleMinMax();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Combining results", ids.size(), LOG) : null;
        DBIDMIter id = ids.iter();
        while (id.valid()) {
            double[] scores = new double[num];
            int i = 0;
            for (OutlierResult r : results) {
                double score = r.getScores().doubleValue((DBIDRef)id);
                if (!Double.isNaN(score)) {
                    scores[i] = score;
                    ++i;
                    continue;
                }
                LOG.warning((CharSequence)("DBID " + id + " was not given a score by result " + r));
            }
            if (i > 0) {
                if (i < scores.length) {
                    scores = Arrays.copyOf(scores, i);
                }
                double combined = this.voting.combine(scores);
                sumscore.putDouble((DBIDRef)id, combined);
                minmax.put(combined);
            } else {
                LOG.warning((CharSequence)("DBID " + id + " was not given any score at all."));
            }
            LOG.incrementProcessed((AbstractProgress)finiteProgress);
            id.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax());
        MaterializedDoubleRelation scores = new MaterializedDoubleRelation("Simple Outlier Ensemble", (DBIDs)ids, (DoubleDataStore)sumscore);
        return new OutlierResult(basicOutlierScoreMeta, (DoubleRelation)scores);
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID VOTING_ID = new OptionID("ensemble.voting", "Voting strategy to use in the ensemble.");
        private List<? extends OutlierAlgorithm> algorithms;
        private EnsembleVoting voting;

        public void configure(Parameterization config) {
            new ObjectListParameter(Algorithm.Utils.ALGORITHM_ID, OutlierAlgorithm.class).grab(config, x -> {
                this.algorithms = x;
            });
            new ObjectParameter(VOTING_ID, EnsembleVoting.class).grab(config, x -> {
                this.voting = x;
            });
        }

        public SimpleOutlierEnsemble make() {
            return new SimpleOutlierEnsemble(this.algorithms, this.voting);
        }
    }
}

