/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.spatial;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.logging.Logging;
import elki.math.DoubleMinMax;
import elki.math.linearalgebra.CovarianceMatrix;
import elki.math.linearalgebra.VMath;
import elki.outlier.spatial.AbstractNeighborhoodOutlier;
import elki.outlier.spatial.neighborhood.NeighborSetPredicate;
import elki.result.Metadata;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.datastructures.QuickSelect;
import elki.utilities.documentation.Reference;

@Reference(authors="C.-T. Lu, D. Chen, Y. Kou", title="Detecting Spatial Outliers with Multiple Attributes", booktitle="Proc. 15th IEEE Int. Conf. Tools with Artificial Intelligence (TAI 2003)", url="https://doi.org/10.1109/TAI.2003.1250179", bibkey="DBLP:conf/ictai/LuCK03")
public class CTLuMedianMultipleAttributes<N, O extends NumberVector>
extends AbstractNeighborhoodOutlier<N> {
    private static final Logging LOG = Logging.getLogger(CTLuMedianMultipleAttributes.class);

    public CTLuMedianMultipleAttributes(NeighborSetPredicate.Factory<N> npredf) {
        super(npredf);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public OutlierResult run(Database database, Relation<N> spatial, Relation<O> attributes) {
        int dim = RelationUtil.dimensionality(attributes);
        if (LOG.isDebugging()) {
            LOG.debug((CharSequence)("Dimensionality: " + dim));
        }
        NeighborSetPredicate npred = this.getNeighborSetPredicateFactory().instantiate(database, spatial);
        CovarianceMatrix covmaker = new CovarianceMatrix(dim);
        WritableDataStore deltas = DataStoreUtil.makeStorage((DBIDs)attributes.getDBIDs(), (int)1, double[].class);
        DBIDIter iditer = attributes.iterDBIDs();
        while (iditer.valid()) {
            NumberVector obj = (NumberVector)attributes.get((DBIDRef)iditer);
            DBIDs neighbors = npred.getNeighborDBIDs((DBIDRef)iditer);
            double[] median = new double[dim];
            double[][] data = new double[dim][neighbors.size()];
            int i = 0;
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                NumberVector nobj = (NumberVector)attributes.get((DBIDRef)iter);
                for (int d = 0; d < dim; ++d) {
                    data[d][i] = nobj.doubleValue(d);
                }
                ++i;
                iter.advance();
            }
            for (int d = 0; d < dim; ++d) {
                median[d] = QuickSelect.median((double[])data[d]);
            }
            double[] delta = VMath.minusEquals((double[])obj.toArray(), (double[])median);
            deltas.put((DBIDRef)iditer, (Object)delta);
            covmaker.put(delta);
            iditer.advance();
        }
        double[] mean = covmaker.getMeanVector();
        double[][] cmati = VMath.inverse((double[][])covmaker.destroyToSampleMatrix());
        DoubleMinMax minmax = new DoubleMinMax();
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)attributes.getDBIDs(), (int)4);
        DBIDIter iditer2 = attributes.iterDBIDs();
        while (iditer2.valid()) {
            double[] v = VMath.minusEquals((double[])((double[])deltas.get((DBIDRef)iditer2)), (double[])mean);
            double score = VMath.transposeTimesTimes((double[])v, (double[][])cmati, (double[])v);
            minmax.put(score);
            scores.putDouble((DBIDRef)iditer2, score);
            iditer2.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Median multiple attributes outlier", attributes.getDBIDs(), (DoubleDataStore)scores);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult or = new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
        Metadata.hierarchyOf((Object)or).addChild((Object)npred);
        return or;
    }

    public static class Par<N, O extends NumberVector>
    extends AbstractNeighborhoodOutlier.Par<N> {
        public CTLuMedianMultipleAttributes<N, O> make() {
            return new CTLuMedianMultipleAttributes(this.npredf);
        }
    }
}

