/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.spatial;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.math.DoubleMinMax;
import elki.math.Mean;
import elki.math.MeanVariance;
import elki.outlier.spatial.AbstractNeighborhoodOutlier;
import elki.outlier.spatial.neighborhood.NeighborSetPredicate;
import elki.result.Metadata;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;

@Title(value="Moran Scatterplot Outlier")
@Description(value="Spatial Outlier detection based on the standardized deviation from the local means.")
@Reference(authors="S. Shekhar, C.-T. Lu, P. Zhang", title="A Unified Approach to Detecting Spatial Outliers", booktitle="GeoInformatica 7-2, 2003", url="https://doi.org/10.1023/A:1023455925009", bibkey="DBLP:journals/geoinformatica/ShekharLZ03")
public class CTLuMoranScatterplotOutlier<N>
extends AbstractNeighborhoodOutlier<N> {
    public CTLuMoranScatterplotOutlier(NeighborSetPredicate.Factory<N> npredf) {
        super(npredf);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D});
    }

    public OutlierResult run(Database database, Relation<N> nrel, Relation<? extends NumberVector> relation) {
        NeighborSetPredicate npred = this.getNeighborSetPredicateFactory().instantiate(database, nrel);
        MeanVariance globalmv = new MeanVariance();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            globalmv.put(((NumberVector)relation.get((DBIDRef)iditer)).doubleValue(0));
            iditer.advance();
        }
        DoubleMinMax minmax = new DoubleMinMax();
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)4);
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            double globalZ = (((NumberVector)relation.get((DBIDRef)iditer2)).doubleValue(0) - globalmv.getMean()) / globalmv.getPopulationStddev();
            Mean localm = new Mean();
            DBIDIter iter = npred.getNeighborDBIDs((DBIDRef)iditer2).iter();
            while (iter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)iditer2, (DBIDRef)iter)) {
                    localm.put((((NumberVector)relation.get((DBIDRef)iter)).doubleValue(0) - globalmv.getMean()) / globalmv.getPopulationStddev());
                }
                iter.advance();
            }
            double localZ = localm.getCount() > 0.0 ? localm.getMean() : globalZ;
            double score = Math.max(-globalZ * localZ, 0.0);
            minmax.put(score);
            scores.putDouble((DBIDRef)iditer2, score);
            iditer2.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("MoranOutlier", relation.getDBIDs(), (DoubleDataStore)scores);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult or = new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
        Metadata.hierarchyOf((Object)or).addChild((Object)npred);
        return or;
    }

    public static class Par<N>
    extends AbstractNeighborhoodOutlier.Par<N> {
        public CTLuMoranScatterplotOutlier<N> make() {
            return new CTLuMoranScatterplotOutlier(this.npredf);
        }
    }
}

