/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.spatial;

import elki.Algorithm;
import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNHeap;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.math.DoubleMinMax;
import elki.math.linearalgebra.VMath;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Title(value="Random Walk on Exhaustive Combination")
@Description(value="Spatial Outlier Detection using Random Walk on Exhaustive Combination")
@Reference(authors="X. Liu, C.-T. Lu, F. Chen", title="Spatial outlier detection: random walk based approaches", booktitle="Proc. SIGSPATIAL Int. Conf. Advances in Geographic Information Systems", url="https://doi.org/10.1145/1869790.1869841", bibkey="DBLP:conf/gis/LiuLC10")
public class CTLuRandomWalkEC<O>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(CTLuRandomWalkEC.class);
    private Distance<? super O> distance;
    private double alpha;
    private double c;
    private int k;

    public CTLuRandomWalkEC(Distance<? super O> distance, double alpha, double c, int k) {
        this.distance = distance;
        this.alpha = alpha;
        this.c = c;
        this.k = k;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D});
    }

    public OutlierResult run(Relation<O> spatial, Relation<? extends NumberVector> relation) {
        DistanceQuery distFunc = new QueryBuilder(spatial, this.distance).distanceQuery();
        WritableDataStore similarityVectors = DataStoreUtil.makeStorage((DBIDs)spatial.getDBIDs(), (int)1, double[].class);
        WritableDataStore neighbors = DataStoreUtil.makeStorage((DBIDs)spatial.getDBIDs(), (int)1, DBIDs.class);
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        double[][] E = new double[ids.size()][ids.size()];
        KNNHeap heap = DBIDUtil.newHeap((int)this.k);
        int i = 0;
        DBIDArrayIter id = ids.iter();
        while (id.valid()) {
            double val = ((NumberVector)relation.get((DBIDRef)id)).doubleValue(0);
            assert (heap.size() == 0);
            int j = 0;
            DBIDArrayIter n = ids.iter();
            while (n.valid()) {
                if (i != j) {
                    double distance = distFunc.distance((DBIDRef)id, (DBIDRef)n);
                    heap.insert(distance, (DBIDRef)n);
                    if (distance == 0.0) {
                        LOG.warning((CharSequence)("Zero distances are not supported - skipping: " + DBIDUtil.toString((DBIDRef)id) + " " + DBIDUtil.toString((DBIDRef)n)));
                    } else {
                        double diff = Math.abs(val - ((NumberVector)relation.get((DBIDRef)n)).doubleValue(0));
                        double exp = FastMath.exp((double)FastMath.pow((double)diff, (double)this.alpha));
                        E[j][i] = exp / distance;
                    }
                }
                n.advance();
                ++j;
            }
            neighbors.put((DBIDRef)id, (Object)heap.unorderedIterator().addTo((ModifiableDBIDs)DBIDUtil.newArray((int)heap.size())));
            id.advance();
            ++i;
        }
        for (i = 0; i < E[0].length; ++i) {
            int j;
            double sum = 0.0;
            for (j = 0; j < E.length; ++j) {
                sum += E[j][i];
            }
            sum = sum != 0.0 ? sum : 1.0;
            for (j = 0; j < E.length; ++j) {
                double[] dArray = E[j];
                int n = i;
                dArray[n] = dArray[n] * (-this.c / sum);
            }
        }
        assert (E.length == E[0].length);
        for (int col = 0; col < E[0].length; ++col) {
            assert (E[col][col] == 0.0);
            E[col][col] = 1.0;
        }
        E = VMath.timesEquals((double[][])VMath.inverse((double[][])E), (double)(1.0 - this.c));
        i = 0;
        id = ids.iter();
        while (id.valid()) {
            similarityVectors.put((DBIDRef)id, (Object)VMath.getCol((double[][])E, (int)i));
            id.advance();
            ++i;
        }
        E = null;
        DoubleMinMax minmax = new DoubleMinMax();
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)spatial.getDBIDs(), (int)4);
        DBIDArrayIter id2 = ids.iter();
        while (id2.valid()) {
            double gmean = 1.0;
            int cnt = 0;
            DBIDIter iter = ((DBIDs)neighbors.get((DBIDRef)id2)).iter();
            while (iter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)id2, (DBIDRef)iter)) {
                    gmean *= VMath.angle((double[])((double[])similarityVectors.get((DBIDRef)id2)), (double[])((double[])similarityVectors.get((DBIDRef)iter)));
                    ++cnt;
                }
                iter.advance();
            }
            double score = cnt > 0 ? FastMath.pow((double)gmean, (double)(1.0 / (double)cnt)) : 1.0;
            minmax.put(score);
            scores.putDouble((DBIDRef)id2, score);
            id2.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("randomwalkec", relation.getDBIDs(), (DoubleDataStore)scores);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("randomwalkec.k", "Number of nearest neighbors to use.");
        public static final OptionID ALPHA_ID = new OptionID("randomwalkec.alpha", "Scaling exponent for value differences.");
        public static final OptionID C_ID = new OptionID("randomwalkec.c", "The damping parameter c.");
        double alpha = 0.5;
        double c = 0.9;
        int k;
        protected Distance<? super O> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            new DoubleParameter(ALPHA_ID, 0.5).grab(config, x -> {
                this.alpha = x;
            });
            new DoubleParameter(C_ID).grab(config, x -> {
                this.c = x;
            });
        }

        public CTLuRandomWalkEC<O> make() {
            return new CTLuRandomWalkEC<O>(this.distance, this.alpha, this.c, this.k);
        }
    }
}

