/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.spatial;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.math.DoubleMinMax;
import elki.math.Mean;
import elki.math.MeanVariance;
import elki.math.linearalgebra.CovarianceMatrix;
import elki.outlier.spatial.AbstractNeighborhoodOutlier;
import elki.outlier.spatial.neighborhood.NeighborSetPredicate;
import elki.result.Metadata;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;

@Title(value="Scatterplot Spatial Outlier")
@Description(value="Spatial Outlier Detection Algorithm using linear regression of attributes and the mean of their neighbors.")
@Reference(authors="S. Shekhar, C.-T. Lu, P. Zhang", title="A Unified Approach to Detecting Spatial Outliers", booktitle="GeoInformatica 7-2, 2003", url="https://doi.org/10.1023/A:1023455925009", bibkey="DBLP:journals/geoinformatica/ShekharLZ03")
public class CTLuScatterplotOutlier<N>
extends AbstractNeighborhoodOutlier<N> {
    public CTLuScatterplotOutlier(NeighborSetPredicate.Factory<N> npredf) {
        super(npredf);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D});
    }

    public OutlierResult run(Database database, Relation<N> nrel, Relation<? extends NumberVector> relation) {
        NeighborSetPredicate npred = this.getNeighborSetPredicateFactory().instantiate(database, nrel);
        WritableDoubleDataStore means = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)1);
        CovarianceMatrix covm = new CovarianceMatrix(2);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double local = ((NumberVector)relation.get((DBIDRef)iditer)).doubleValue(0);
            Mean mean = new Mean();
            DBIDs neighbors = npred.getNeighborDBIDs((DBIDRef)iditer);
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)iditer, (DBIDRef)iter)) {
                    mean.put(((NumberVector)relation.get((DBIDRef)iter)).doubleValue(0));
                }
                iter.advance();
            }
            double m = mean.getCount() > 0.0 ? mean.getMean() : local;
            means.putDouble((DBIDRef)iditer, m);
            covm.put(new double[]{local, m});
            iditer.advance();
        }
        double[] meanv = covm.getMeanVector();
        double[][] fmat = covm.destroyToSampleMatrix();
        double covxx = fmat[0][0];
        double covxy = fmat[0][1];
        double slope = covxy / covxx;
        double inter = meanv[1] - slope * meanv[0];
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)4);
        MeanVariance mv = new MeanVariance();
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            double y_i = ((NumberVector)relation.get((DBIDRef)iditer2)).doubleValue(0);
            double e = means.doubleValue((DBIDRef)iditer2) - (slope * y_i + inter);
            scores.putDouble((DBIDRef)iditer2, e);
            mv.put(e);
            iditer2.advance();
        }
        DoubleMinMax minmax = new DoubleMinMax();
        double mean = mv.getMean();
        double variance = mv.getPopulationStddev();
        DBIDIter iditer3 = relation.iterDBIDs();
        while (iditer3.valid()) {
            double score = Math.abs((scores.doubleValue((DBIDRef)iditer3) - mean) / variance);
            minmax.put(score);
            scores.putDouble((DBIDRef)iditer3, score);
            iditer3.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("SPO", relation.getDBIDs(), (DoubleDataStore)scores);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult or = new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
        Metadata.hierarchyOf((Object)or).addChild((Object)npred);
        return or;
    }

    public static class Par<N>
    extends AbstractNeighborhoodOutlier.Par<N> {
        public CTLuScatterplotOutlier<N> make() {
            return new CTLuScatterplotOutlier(this.npredf);
        }
    }
}

