/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.spatial;

import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.distance.PrimitiveDistance;
import elki.math.DoubleMinMax;
import elki.outlier.spatial.AbstractDistanceBasedSpatialOutlier;
import elki.outlier.spatial.neighborhood.NeighborSetPredicate;
import elki.result.Metadata;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;

@Title(value="SLOM: a new measure for local spatial outliers")
@Description(value="Spatial local outlier measure (SLOM), which captures the local behaviour of datum in their spatial neighbourhood")
@Reference(authors="S. Chawla, P. Sun", title="SLOM: a new measure for local spatial outliers", booktitle="Knowledge and Information Systems 9(4)", url="https://doi.org/10.1007/s10115-005-0200-2", bibkey="DBLP:journals/kais/ChawlaS06")
public class SLOM<N, O>
extends AbstractDistanceBasedSpatialOutlier<N, O> {
    public SLOM(NeighborSetPredicate.Factory<N> npred, PrimitiveDistance<O> nonSpatialDistance) {
        super(npred, nonSpatialDistance);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public OutlierResult run(Database database, Relation<N> spatial, Relation<O> relation) {
        DBIDs neighbors;
        int cnt;
        NeighborSetPredicate npred = this.getNeighborSetPredicateFactory().instantiate(database, spatial);
        DistanceQuery distFunc = this.getNonSpatialDistance().instantiate(relation);
        WritableDoubleDataStore modifiedDistance = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)3);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double sum = 0.0;
            double maxDist = 0.0;
            cnt = 0;
            neighbors = npred.getNeighborDBIDs((DBIDRef)iditer);
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)iditer, (DBIDRef)iter)) {
                    double dist = distFunc.distance((DBIDRef)iditer, (DBIDRef)iter);
                    sum += dist;
                    ++cnt;
                    maxDist = Math.max(maxDist, dist);
                }
                iter.advance();
            }
            if (cnt > 1) {
                modifiedDistance.putDouble((DBIDRef)iditer, (sum - maxDist) / (double)(cnt - 1));
            } else {
                modifiedDistance.putDouble((DBIDRef)iditer, maxDist);
            }
            iditer.advance();
        }
        DoubleMinMax slomminmax = new DoubleMinMax();
        WritableDoubleDataStore sloms = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)4);
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            double slom;
            double sum = 0.0;
            cnt = 0;
            neighbors = npred.getNeighborDBIDs((DBIDRef)iditer2);
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)iditer2, (DBIDRef)iter)) {
                    sum += modifiedDistance.doubleValue((DBIDRef)iter);
                    ++cnt;
                }
                iter.advance();
            }
            if (cnt > 0) {
                double avgPlus = (sum + modifiedDistance.doubleValue((DBIDRef)iditer2)) / (double)(cnt + 1);
                double avg = sum / (double)cnt;
                double beta = 0.0;
                DBIDIter iter2 = neighbors.iter();
                while (iter2.valid()) {
                    double dist = modifiedDistance.doubleValue((DBIDRef)iter2);
                    if (dist > avgPlus) {
                        beta += 1.0;
                    } else if (dist < avgPlus) {
                        beta -= 1.0;
                    }
                    iter2.advance();
                }
                if (!neighbors.contains((DBIDRef)iditer2)) {
                    double dist = modifiedDistance.doubleValue((DBIDRef)iditer2);
                    if (dist > avgPlus) {
                        beta += 1.0;
                    } else if (dist < avgPlus) {
                        beta -= 1.0;
                    }
                }
                beta = Math.abs(beta);
                beta = cnt > 1 ? Math.max(beta, 1.0) / (double)(cnt - 1) : 1.0;
                slom = (beta /= 1.0 + avg) * modifiedDistance.doubleValue((DBIDRef)iditer2);
            } else {
                slom = 0.0;
            }
            sloms.putDouble((DBIDRef)iditer2, slom);
            slomminmax.put(slom);
            iditer2.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("SLOM", relation.getDBIDs(), (DoubleDataStore)sloms);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(slomminmax.getMin(), slomminmax.getMax(), 0.0, Double.POSITIVE_INFINITY);
        OutlierResult or = new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
        Metadata.hierarchyOf((Object)or).addChild((Object)npred);
        return or;
    }

    public static class Par<N, O>
    extends AbstractDistanceBasedSpatialOutlier.Par<N, O> {
        public SLOM<N, O> make() {
            return new SLOM(this.npredf, this.distance);
        }
    }
}

