/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.spatial;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.DoubleMinMax;
import elki.math.Mean;
import elki.outlier.spatial.AbstractNeighborhoodOutlier;
import elki.outlier.spatial.neighborhood.NeighborSetPredicate;
import elki.result.Metadata;
import elki.result.outlier.BasicOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.datastructures.QuickSelect;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Arrays;

@Title(value="A Trimmed Mean Approach to Finding Spatial Outliers")
@Description(value="A local trimmed mean approach to evaluating the spatial outlier factor which is the degree that a site is outlying compared to its neighbors")
@Reference(authors="T. Hu, S. Y. Sung", title="A trimmed mean approach to finding spatial outliers", booktitle="Intelligent Data Analysis 8", url="http://content.iospress.com/articles/intelligent-data-analysis/ida00153", bibkey="DBLP:journals/ida/HuS04")
public class TrimmedMeanApproach<N>
extends AbstractNeighborhoodOutlier<N> {
    private static final Logging LOG = Logging.getLogger(TrimmedMeanApproach.class);
    private double p;

    public TrimmedMeanApproach(NeighborSetPredicate.Factory<N> npredf, double p) {
        super(npredf);
        this.p = p;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D});
    }

    public OutlierResult run(Database database, Relation<N> nrel, Relation<? extends NumberVector> relation) {
        assert (RelationUtil.dimensionality(relation) == 1) : "TrimmedMean can only process one-dimensional data sets.";
        NeighborSetPredicate npred = this.getNeighborSetPredicateFactory().instantiate(database, nrel);
        WritableDoubleDataStore errors = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)1);
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)4);
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Computing trimmed means", relation.size(), LOG) : null;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double tm;
            DBIDs neighbors = npred.getNeighborDBIDs((DBIDRef)iditer);
            int num = 0;
            double[] values = new double[neighbors.size()];
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                values[num] = ((NumberVector)relation.get((DBIDRef)iter)).doubleValue(0);
                ++num;
                iter.advance();
            }
            if (num > 0) {
                int left = (int)Math.floor(this.p * (double)(num - 1));
                int right = (int)Math.floor((1.0 - this.p) * (double)(num - 1));
                Arrays.sort(values, 0, num);
                Mean mean = new Mean();
                for (int i = left; i <= right; ++i) {
                    mean.put(values[i]);
                }
                tm = mean.getMean();
            } else {
                tm = ((NumberVector)relation.get((DBIDRef)iditer)).doubleValue(0);
            }
            errors.putDouble((DBIDRef)iditer, ((NumberVector)relation.get((DBIDRef)iditer)).doubleValue(0) - tm);
            LOG.incrementProcessed((AbstractProgress)progress);
            iditer.advance();
        }
        LOG.ensureCompleted(progress);
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)"Computing median error.");
        }
        double[] ei = new double[relation.size()];
        int i = 0;
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            ei[i] = errors.doubleValue((DBIDRef)iditer2);
            ++i;
            iditer2.advance();
        }
        double median_i = QuickSelect.median((double[])ei);
        for (int i2 = 0; i2 < ei.length; ++i2) {
            ei[i2] = Math.abs(ei[i2] - median_i);
        }
        double median_dev_from_median = QuickSelect.median((double[])ei);
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)"Normalizing scores.");
        }
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter iditer3 = relation.iterDBIDs();
        while (iditer3.valid()) {
            double score = Math.abs(errors.doubleValue((DBIDRef)iditer3)) * 0.6745 / median_dev_from_median;
            scores.putDouble((DBIDRef)iditer3, score);
            minmax.put(score);
            iditer3.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("TrimmedMean", relation.getDBIDs(), (DoubleDataStore)scores);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult or = new OutlierResult(scoreMeta, (DoubleRelation)scoreResult);
        Metadata.hierarchyOf((Object)or).addChild((Object)npred);
        return or;
    }

    public static class Par<N>
    extends AbstractNeighborhoodOutlier.Par<N> {
        public static final OptionID P_ID = new OptionID("tma.p", "the percentile parameter");
        protected double p = 0.2;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(P_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_HALF_DOUBLE)).grab(config, x -> {
                this.p = x;
            });
        }

        public TrimmedMeanApproach<N> make() {
            return new TrimmedMeanApproach(this.npredf, this.p);
        }
    }
}

