/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.spatial.neighborhood;

import elki.database.datastore.DataStore;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.logging.Logging;
import elki.outlier.spatial.neighborhood.NeighborSetPredicate;

public abstract class AbstractPrecomputedNeighborhood
implements NeighborSetPredicate {
    protected DataStore<DBIDs> store;

    public AbstractPrecomputedNeighborhood(DataStore<DBIDs> store) {
        this.store = store;
    }

    @Override
    public DBIDs getNeighborDBIDs(DBIDRef reference) {
        DBIDs neighbors = (DBIDs)this.store.get(reference);
        if (neighbors != null) {
            return neighbors;
        }
        if (this.getLogger().isDebugging()) {
            this.getLogger().warning((CharSequence)("No neighbors for object " + reference));
        }
        return DBIDUtil.deref((DBIDRef)reference);
    }

    protected abstract Logging getLogger();

    public static abstract class Factory<O>
    implements NeighborSetPredicate.Factory<O> {
    }
}

