/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.spatial.neighborhood;

import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.outlier.spatial.neighborhood.AbstractPrecomputedNeighborhood;
import elki.outlier.spatial.neighborhood.NeighborSetPredicate;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public class PrecomputedKNearestNeighborNeighborhood
extends AbstractPrecomputedNeighborhood {
    private static final Logging LOG = Logging.getLogger(PrecomputedKNearestNeighborNeighborhood.class);

    public PrecomputedKNearestNeighborNeighborhood(DataStore<DBIDs> store) {
        super(store);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory<O>
    implements NeighborSetPredicate.Factory<O> {
        private int k;
        private Distance<? super O> distance;

        public Factory(int k, Distance<? super O> distance) {
            this.k = k;
            this.distance = distance;
        }

        @Override
        public NeighborSetPredicate instantiate(Database database, Relation<? extends O> relation) {
            KNNSearcher knnQuery = new QueryBuilder(relation, this.distance).kNNByDBID(this.k);
            WritableDataStore s = DataStoreUtil.makeStorage((DBIDs)relation.getDBIDs(), (int)6, DBIDs.class);
            DBIDIter iditer = relation.iterDBIDs();
            while (iditer.valid()) {
                KNNList neighbors = knnQuery.getKNN((Object)iditer, this.k);
                ArrayModifiableDBIDs neighbours = DBIDUtil.newArray((int)neighbors.size());
                DoubleDBIDListIter neighbor = neighbors.iter();
                while (neighbor.valid()) {
                    neighbours.add((DBIDRef)neighbor);
                    neighbor.advance();
                }
                s.put((DBIDRef)iditer, (Object)neighbours);
                iditer.advance();
            }
            return new PrecomputedKNearestNeighborNeighborhood((DataStore<DBIDs>)s);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.distance.getInputTypeRestriction();
        }

        public static class Par<O>
        implements Parameterizer {
            public static final OptionID K_ID = new OptionID("neighborhood.k", "the number of neighbors");
            public static final OptionID DISTANCEFUNCTION_ID = new OptionID("neighborhood.distancefunction", "the distance function to use");
            int k;
            Distance<? super O> distFunc;

            public void configure(Parameterization config) {
                new IntParameter(K_ID).grab(config, x -> {
                    this.k = x;
                });
                new ObjectParameter(DISTANCEFUNCTION_ID, Distance.class).grab(config, x -> {
                    this.distFunc = x;
                });
            }

            public Factory<O> make() {
                return new Factory<O>(this.k, this.distFunc);
            }
        }
    }
}

