/*
 * Decompiled with CFR 0.152.
 */
package elki.outlier.trivial;

import elki.data.type.NoSupportedDataTypeException;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.MaterializedDoubleRelation;
import elki.database.relation.Relation;
import elki.outlier.OutlierAlgorithm;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.ProbabilisticOutlierScore;
import elki.utilities.Priority;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.regex.Pattern;

@Priority(value=-100)
public class ByLabelOutlier
implements OutlierAlgorithm {
    public static final String DEFAULT_PATTERN = ".*(Outlier|Noise).*";
    final Pattern pattern;

    public ByLabelOutlier(Pattern pattern) {
        this.pattern = pattern;
    }

    public ByLabelOutlier() {
        this(Pattern.compile(DEFAULT_PATTERN));
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.GUESSED_LABEL});
    }

    @Override
    public OutlierResult autorun(Database database) {
        try {
            return this.run(database.getRelation((TypeInformation)TypeUtil.CLASSLABEL, new Object[0]));
        }
        catch (NoSupportedDataTypeException e) {
            return this.run(database.getRelation(this.getInputTypeRestriction()[0], new Object[0]));
        }
    }

    public OutlierResult run(Relation<?> relation) {
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)2);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            String label = relation.get((DBIDRef)iditer).toString();
            double score = this.pattern.matcher(label).matches() ? 1.0 : 0.0;
            scores.putDouble((DBIDRef)iditer, score);
            iditer.advance();
        }
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("By label outlier scores", relation.getDBIDs(), (DoubleDataStore)scores);
        ProbabilisticOutlierScore meta = new ProbabilisticOutlierScore();
        return new OutlierResult(meta, (DoubleRelation)scoreres);
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID OUTLIER_PATTERN_ID = new OptionID("outlier.pattern", "Label pattern to match outliers.");
        private Pattern pattern;

        public void configure(Parameterization config) {
            new PatternParameter(OUTLIER_PATTERN_ID, ByLabelOutlier.DEFAULT_PATTERN).grab(config, x -> {
                this.pattern = x;
            });
        }

        public ByLabelOutlier make() {
            return new ByLabelOutlier(this.pattern);
        }
    }
}

