/*
 * Decompiled with CFR 0.152.
 */
package elki.result.outlier;

import elki.result.outlier.BasicOutlierScoreMeta;

public class InvertedOutlierScoreMeta
extends BasicOutlierScoreMeta {
    public InvertedOutlierScoreMeta(double actualMinimum, double actualMaximum, double theoreticalMinimum, double theoreticalMaximum, double theoreticalBaseline) {
        super(actualMinimum, actualMaximum, theoreticalMinimum, theoreticalMaximum, theoreticalBaseline);
    }

    public InvertedOutlierScoreMeta(double actualMinimum, double actualMaximum, double theoreticalMinimum, double theoreticalMaximum) {
        super(actualMinimum, actualMaximum, theoreticalMinimum, theoreticalMaximum);
    }

    public InvertedOutlierScoreMeta(double actualMinimum, double actualMaximum) {
        super(actualMinimum, actualMaximum);
    }

    @Override
    public double normalizeScore(double value) {
        double center = 0.0;
        if (!Double.isNaN(this.theoreticalBaseline) && !Double.isInfinite(this.theoreticalBaseline)) {
            center = this.theoreticalBaseline;
        } else if (!Double.isNaN(this.theoreticalMaximum) && !Double.isInfinite(this.theoreticalMaximum)) {
            center = this.theoreticalMaximum;
        } else if (!Double.isNaN(this.actualMaximum) && !Double.isInfinite(this.actualMaximum)) {
            center = this.actualMaximum;
        }
        if (value > center) {
            return 0.0;
        }
        double min = Double.NaN;
        if (!Double.isNaN(this.theoreticalMinimum) && !Double.isInfinite(this.theoreticalMinimum)) {
            min = this.theoreticalMinimum;
        } else if (!Double.isNaN(this.actualMinimum) && !Double.isInfinite(this.actualMinimum)) {
            min = this.actualMinimum;
        }
        if (!Double.isNaN(min) && !Double.isInfinite(min) && min <= center) {
            return (center - value) / (center - min);
        }
        return center - value;
    }
}

