/*
 * Decompiled with CFR 0.152.
 */
package elki.result.outlier;

import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.evaluation.scores.ScoreEvaluation;
import elki.evaluation.scores.adapter.OutlierScoreAdapter;
import elki.result.Metadata;
import elki.result.OrderingResult;
import elki.result.outlier.InvertedOutlierScoreMeta;
import elki.result.outlier.OrderingFromRelation;
import elki.result.outlier.OutlierScoreMeta;
import java.util.ArrayList;
import java.util.List;

public class OutlierResult {
    private OutlierScoreMeta meta;
    private DoubleRelation scores;
    private OrderingResult ordering;

    public OutlierResult(OutlierScoreMeta meta, DoubleRelation scores) {
        this.meta = meta;
        this.scores = scores;
        this.ordering = new OrderingFromRelation(scores, meta instanceof InvertedOutlierScoreMeta);
        Metadata.of((Object)this).setLongName(scores.getLongName());
        Metadata.Hierarchy hier = Metadata.hierarchyOf((Object)this);
        hier.addChild((Object)scores);
        hier.addChild((Object)this.ordering);
        hier.addChild((Object)meta);
    }

    public OutlierScoreMeta getOutlierMeta() {
        return this.meta;
    }

    public DoubleRelation getScores() {
        return this.scores;
    }

    public OrderingResult getOrdering() {
        return this.ordering;
    }

    public static List<OutlierResult> getOutlierResults(Object r) {
        return (List)Metadata.hierarchyOf((Object)r).iterDescendantsSelf().filter(OutlierResult.class).collect(new ArrayList());
    }

    double evaluateBy(ScoreEvaluation eval) {
        return eval.evaluate((ScoreEvaluation.Adapter)new OutlierScoreAdapter((DBIDs)DBIDUtil.ensureSet((DBIDs)this.scores.getDBIDs()), this));
    }
}

