/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.scaling.outlier;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.DoubleRelation;
import elki.math.DoubleMinMax;
import elki.math.MeanVariance;
import elki.math.statistics.distribution.GammaDistribution;
import elki.result.outlier.OutlierResult;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.scaling.outlier.OutlierGammaScaling;
import net.jafama.FastMath;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM 2011)", url="https://doi.org/10.1137/1.9781611972818.2", bibkey="DBLP:conf/sdm/KriegelKSZ11")
public class MinusLogGammaScaling
extends OutlierGammaScaling {
    double max = 0.0;
    double mlogmax;

    public MinusLogGammaScaling() {
        super(false);
    }

    @Override
    protected double preScale(double score) {
        assert (this.max > 0.0) : "prepare() was not run prior to using the scaling function.";
        return -FastMath.log((double)(score / this.max)) / this.mlogmax;
    }

    @Override
    public void prepare(OutlierResult or) {
        this.meta = or.getOutlierMeta();
        DoubleMinMax mm = new DoubleMinMax();
        DoubleRelation scores = or.getScores();
        DBIDIter id = scores.iterDBIDs();
        while (id.valid()) {
            double score = scores.doubleValue((DBIDRef)id);
            if (!Double.isNaN(score) && !Double.isInfinite(score)) {
                mm.put(score);
            }
            id.advance();
        }
        this.max = mm.getMax();
        this.mlogmax = -FastMath.log((double)(mm.getMin() / this.max));
        MeanVariance mv = new MeanVariance();
        DBIDIter id2 = scores.iterDBIDs();
        while (id2.valid()) {
            double score = this.preScale(scores.doubleValue((DBIDRef)id2));
            if (!Double.isNaN(score) && !Double.isInfinite(score)) {
                mv.put(score);
            }
            id2.advance();
        }
        double mean = mv.getMean();
        double var = mv.getSampleVariance();
        this.k = mean * mean / var;
        this.theta = var / mean;
        this.atmean = GammaDistribution.regularizedGammaP((double)this.k, (double)(mean / this.theta));
    }

    public static class Par
    implements Parameterizer {
        public MinusLogGammaScaling make() {
            return new MinusLogGammaScaling();
        }
    }
}

