/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.scaling.outlier;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.DoubleRelation;
import elki.math.MeanVariance;
import elki.math.statistics.distribution.GammaDistribution;
import elki.result.outlier.OutlierResult;
import elki.result.outlier.OutlierScoreMeta;
import elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.scaling.outlier.OutlierScaling;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM 2011)", url="https://doi.org/10.1137/1.9781611972818.2", bibkey="DBLP:conf/sdm/KriegelKSZ11")
public class OutlierGammaScaling
implements OutlierScaling {
    double k;
    double theta;
    double atmean = 0.5;
    boolean normalize = false;
    OutlierScoreMeta meta = null;

    public OutlierGammaScaling(boolean normalize) {
        this.normalize = normalize;
    }

    public double getScaled(double value) {
        assert (this.theta > 0.0) : "prepare() was not run prior to using the scaling function.";
        return Double.isNaN(value = this.preScale(value)) || Double.isInfinite(value) ? 1.0 : Math.max(0.0, (GammaDistribution.regularizedGammaP((double)this.k, (double)(value / this.theta)) - this.atmean) / (1.0 - this.atmean));
    }

    @Override
    public void prepare(OutlierResult or) {
        this.meta = or.getOutlierMeta();
        MeanVariance mv = new MeanVariance();
        DoubleRelation scores = or.getScores();
        DBIDIter id = scores.iterDBIDs();
        while (id.valid()) {
            double score = this.preScale(scores.doubleValue((DBIDRef)id));
            if (!Double.isNaN(score) && !Double.isInfinite(score)) {
                mv.put(score);
            }
            id.advance();
        }
        double mean = mv.getMean();
        double var = mv.getSampleVariance();
        this.k = mean * mean / var;
        this.theta = var / mean;
        this.atmean = GammaDistribution.regularizedGammaP((double)this.k, (double)(mean / this.theta));
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        MeanVariance mv = new MeanVariance();
        int size = adapter.size(array);
        for (int i = 0; i < size; ++i) {
            double score = this.preScale(adapter.getDouble(array, i));
            if (Double.isNaN(score) || Double.isInfinite(score)) continue;
            mv.put(score);
        }
        double mean = mv.getMean();
        double var = mv.getSampleVariance();
        this.k = mean * mean / var;
        this.theta = var / mean;
        this.atmean = GammaDistribution.regularizedGammaP((double)this.k, (double)(mean / this.theta));
    }

    protected double preScale(double score) {
        return this.normalize ? this.meta.normalizeScore(score) : score;
    }

    public double getMin() {
        return 0.0;
    }

    public double getMax() {
        return 1.0;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID NORMALIZE_ID = new OptionID("gammascale.normalize", "Regularize scores before using Gamma scaling.");
        protected boolean normalize = false;

        public void configure(Parameterization config) {
            new Flag(NORMALIZE_ID).grab(config, x -> {
                this.normalize = x;
            });
        }

        public OutlierGammaScaling make() {
            return new OutlierGammaScaling(this.normalize);
        }
    }
}

