/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.scaling.outlier;

import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.DoubleRelation;
import elki.result.outlier.InvertedOutlierScoreMeta;
import elki.result.outlier.OutlierResult;
import elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.scaling.outlier.OutlierScaling;

public class OutlierLinearScaling
implements OutlierScaling {
    protected Double min = null;
    protected Double max = null;
    double factor;
    boolean usemean = false;
    boolean nozeros = false;

    public OutlierLinearScaling() {
        this(null, null, false, false);
    }

    public OutlierLinearScaling(Double min, Double max, boolean usemean, boolean nozeros) {
        this.min = min;
        this.max = max;
        this.usemean = usemean;
        this.nozeros = nozeros;
        if (min != null && max != null) {
            this.factor = max - min;
        }
    }

    public double getScaled(double value) {
        assert (this.factor != 0.0) : "prepare() was not run prior to using the scaling function.";
        if (this.factor < 0.0) {
            return value >= this.max ? 0.0 : Math.min(1.0, (value - this.max) / this.factor);
        }
        return value <= this.min ? 0.0 : Math.min(1.0, (value - this.min) / this.factor);
    }

    @Override
    public void prepare(OutlierResult or) {
        if (this.min == null || this.max == null || this.usemean) {
            double mi = Double.MAX_VALUE;
            double ma = Double.MIN_VALUE;
            double sum = 0.0;
            int count = 0;
            int skippedzeros = 0;
            DoubleRelation scores = or.getScores();
            DBIDIter id = scores.iterDBIDs();
            while (id.valid()) {
                double val = scores.doubleValue((DBIDRef)id);
                if (this.nozeros && val == 0.0) {
                    ++skippedzeros;
                } else {
                    sum += val;
                    ++count;
                    mi = val < mi ? val : mi;
                    ma = val > ma ? val : ma;
                }
                id.advance();
            }
            if (count == 0 && skippedzeros > 0) {
                ma = 0.0;
                mi = 0.0;
                sum = 0.0;
            }
            this.min = this.usemean && count > 0 ? sum / (double)count : (this.min != null ? this.min : mi);
            this.max = this.max != null ? this.max : ma;
        }
        double d = this.factor = this.max > this.min ? this.max - this.min : 1.0;
        if (or.getOutlierMeta() instanceof InvertedOutlierScoreMeta) {
            this.factor *= -1.0;
        }
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        if (this.min == null || this.max == null || this.usemean) {
            double mi = Double.MAX_VALUE;
            double ma = Double.MIN_VALUE;
            double sum = 0.0;
            int count = 0;
            int skippedzeros = 0;
            int size = adapter.size(array);
            for (int i = 0; i < size; ++i) {
                double val = adapter.getDouble(array, i);
                if (this.nozeros && val == 0.0) {
                    ++skippedzeros;
                    continue;
                }
                sum += val;
                ++count;
                mi = val < mi ? val : mi;
                ma = val > ma ? val : ma;
            }
            if (count == 0 && skippedzeros > 0) {
                ma = 0.0;
                mi = 0.0;
                sum = 0.0;
            }
            this.min = this.usemean && count > 0 ? sum / (double)count : (this.min != null ? this.min : mi);
            this.max = this.max != null ? this.max : ma;
        }
        this.factor = this.max > this.min ? this.max - this.min : 1.0;
    }

    public double getMin() {
        return 0.0;
    }

    public double getMax() {
        return 1.0;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID MIN_ID = new OptionID("linearscale.min", "Fixed minimum to use in linear scaling.");
        public static final OptionID MAX_ID = new OptionID("linearscale.max", "Fixed maximum to use in linear scaling.");
        public static final OptionID MEAN_ID = new OptionID("linearscale.usemean", "Use the mean as minimum for scaling.");
        public static final OptionID NOZEROS_ID = new OptionID("linearscale.ignorezero", "Ignore zero entries when computing the minimum and maximum.");
        protected Double min = null;
        protected Double max = null;
        boolean usemean = false;
        boolean nozeros = false;

        public void configure(Parameterization config) {
            ((DoubleParameter)new DoubleParameter(MIN_ID).setOptional(true)).grab(config, x -> {
                this.min = x;
            });
            ((DoubleParameter)new DoubleParameter(MAX_ID).setOptional(true)).grab(config, x -> {
                this.max = x;
            });
            if (this.min == null && this.max == null) {
                new Flag(MEAN_ID).grab(config, x -> {
                    this.usemean = x;
                });
            }
            new Flag(NOZEROS_ID).grab(config, x -> {
                this.nozeros = x;
            });
        }

        public OutlierLinearScaling make() {
            return new OutlierLinearScaling(this.min, this.max, this.usemean, this.nozeros);
        }
    }
}

