/*
 * Decompiled with CFR 0.152.
 */
package elki.persistent;

import elki.logging.Logging;
import elki.logging.statistics.Counter;
import elki.logging.statistics.Statistic;
import elki.persistent.Page;
import elki.persistent.PageFile;

public abstract class AbstractPageFile<P extends Page>
implements PageFile<P> {
    private Counter readAccess;
    private Counter writeAccess;

    public AbstractPageFile() {
        Logging log = this.getLogger();
        this.readAccess = log.isStatistics() ? log.newCounter(this.getClass().getName() + ".reads") : null;
        this.writeAccess = log.isStatistics() ? log.newCounter(this.getClass().getName() + ".writes") : null;
    }

    protected abstract Logging getLogger();

    @Override
    public final synchronized int writePage(P page) {
        int pageid = this.setPageID(page);
        this.writePage(pageid, page);
        return pageid;
    }

    protected abstract void writePage(int var1, P var2);

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void logStatistics() {
        if (this.readAccess != null) {
            this.getLogger().statistics((Statistic)this.readAccess);
        }
        if (this.writeAccess != null) {
            this.getLogger().statistics((Statistic)this.writeAccess);
        }
    }

    protected void countRead() {
        if (this.readAccess != null) {
            this.readAccess.increment();
        }
    }

    protected void countWrite() {
        if (this.writeAccess != null) {
            this.writeAccess.increment();
        }
    }
}

