/*
 * Decompiled with CFR 0.152.
 */
package elki.persistent;

import elki.persistent.Page;
import elki.persistent.PageFileFactory;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;

public abstract class AbstractPageFileFactory<P extends Page>
implements PageFileFactory<P> {
    protected int pageSize;

    public AbstractPageFileFactory(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    public static abstract class Par<P extends Page>
    implements Parameterizer {
        public static final OptionID PAGE_SIZE_ID = new OptionID("pagefile.pagesize", "The size of a page in bytes.");
        protected int pageSize;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(PAGE_SIZE_ID, 4000).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.pageSize = x;
            });
        }

        public abstract PageFileFactory<P> make();
    }
}

